/*
 * Decompiled with CFR 0.152.
 */
package mezz.jei.library.plugins.vanilla.brewing;

import java.util.List;
import mezz.jei.api.constants.RecipeTypes;
import mezz.jei.api.gui.ITickTimer;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.builder.IRecipeSlotBuilder;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.drawable.IDrawableAnimated;
import mezz.jei.api.gui.drawable.IDrawableStatic;
import mezz.jei.api.gui.ingredient.IRecipeSlotsView;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.RecipeIngredientRole;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import mezz.jei.api.recipe.vanilla.IJeiBrewingRecipe;
import mezz.jei.common.Internal;
import mezz.jei.common.gui.textures.Textures;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Blocks;
import org.jetbrains.annotations.Nullable;

public class BrewingRecipeCategory
implements IRecipeCategory<IJeiBrewingRecipe> {
    private final IDrawable backgroundArea;
    private final IDrawable backgroundImage;
    private final IDrawable icon;
    private final Component localizedName;
    private final IDrawableAnimated arrow;
    private final IDrawableAnimated bubbles;
    private final IDrawableStatic blazeHeat;

    public BrewingRecipeCategory(IGuiHelper guiHelper) {
        this.backgroundArea = guiHelper.createBlankDrawable(114, 61);
        Textures textures = Internal.getTextures();
        this.backgroundImage = textures.getBrewingStandBackground();
        this.icon = guiHelper.createDrawableItemLike((ItemLike)Blocks.BREWING_STAND);
        this.localizedName = Component.translatable((String)"gui.jei.category.brewing");
        this.arrow = guiHelper.createAnimatedDrawable(textures.getBrewingStandArrow(), 400, IDrawableAnimated.StartDirection.TOP, false);
        BrewingBubblesTickTimer bubblesTickTimer = new BrewingBubblesTickTimer(guiHelper);
        this.bubbles = guiHelper.createAnimatedDrawable(textures.getBrewingStandBubbles(), (ITickTimer)bubblesTickTimer, IDrawableAnimated.StartDirection.BOTTOM);
        this.blazeHeat = textures.getBrewingStandBlazeHeat();
    }

    public RecipeType<IJeiBrewingRecipe> getRecipeType() {
        return RecipeTypes.BREWING;
    }

    public Component getTitle() {
        return this.localizedName;
    }

    public IDrawable getBackground() {
        return this.backgroundArea;
    }

    public IDrawable getIcon() {
        return this.icon;
    }

    public void draw(IJeiBrewingRecipe recipe, IRecipeSlotsView recipeSlotsView, GuiGraphics guiGraphics, double mouseX, double mouseY) {
        this.backgroundImage.draw(guiGraphics, 0, 1);
        this.blazeHeat.draw(guiGraphics, 5, 30);
        this.bubbles.draw(guiGraphics, 9, 1);
        this.arrow.draw(guiGraphics, 43, 3);
        int brewingSteps = recipe.getBrewingSteps();
        String brewingStepsString = brewingSteps < Integer.MAX_VALUE ? Integer.toString(brewingSteps) : "?";
        MutableComponent steps = Component.translatable((String)"gui.jei.category.brewing.steps", (Object[])new Object[]{brewingStepsString});
        Minecraft minecraft = Minecraft.getInstance();
        guiGraphics.drawString(minecraft.font, (Component)steps, 70, 28, -8355712, false);
    }

    public void setRecipe(IRecipeLayoutBuilder builder, IJeiBrewingRecipe recipe, IFocusGroup focuses) {
        List potionInputs = recipe.getPotionInputs();
        builder.addSlot(RecipeIngredientRole.INPUT, 1, 37).addItemStacks(potionInputs);
        builder.addSlot(RecipeIngredientRole.INPUT, 24, 44).addItemStacks(potionInputs);
        builder.addSlot(RecipeIngredientRole.INPUT, 47, 37).addItemStacks(potionInputs);
        builder.addSlot(RecipeIngredientRole.INPUT, 24, 3).addItemStacks(recipe.getIngredients());
        ((IRecipeSlotBuilder)builder.addSlot(RecipeIngredientRole.OUTPUT, 81, 3).addItemStack(recipe.getPotionOutput())).setStandardSlotBackground();
    }

    @Nullable
    public ResourceLocation getRegistryName(IJeiBrewingRecipe recipe) {
        return recipe.getUid();
    }

    private static class BrewingBubblesTickTimer
    implements ITickTimer {
        private static final int[] BUBBLE_LENGTHS = new int[]{29, 23, 18, 13, 9, 5, 0};
        private final ITickTimer internalTimer;

        public BrewingBubblesTickTimer(IGuiHelper guiHelper) {
            this.internalTimer = guiHelper.createTickTimer(14, BUBBLE_LENGTHS.length - 1, false);
        }

        public int getValue() {
            int timerValue = this.internalTimer.getValue();
            return BUBBLE_LENGTHS[timerValue];
        }

        public int getMaxValue() {
            return BUBBLE_LENGTHS[0];
        }
    }
}

