/*
 * Decompiled with CFR 0.152.
 */
package mezz.jei.library.plugins.debug;

import java.util.List;
import mezz.jei.api.gui.builder.IIngredientAcceptor;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.builder.IRecipeSlotBuilder;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.helpers.IPlatformFluidHelper;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.RecipeIngredientRole;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import mezz.jei.library.plugins.debug.DebugRecipe;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;

public class DebugFocusRecipeCategory<F>
implements IRecipeCategory<DebugRecipe> {
    public static final RecipeType<DebugRecipe> TYPE = RecipeType.create((String)"jei", (String)"debug_focus", DebugRecipe.class);
    public static final int RECIPE_WIDTH = 160;
    public static final int RECIPE_HEIGHT = 60;
    private final IDrawable background;
    private final IPlatformFluidHelper<F> platformFluidHelper;
    private final Component localizedName;

    public DebugFocusRecipeCategory(IGuiHelper guiHelper, IPlatformFluidHelper<F> platformFluidHelper) {
        this.background = guiHelper.createBlankDrawable(160, 60);
        this.platformFluidHelper = platformFluidHelper;
        this.localizedName = Component.literal((String)"debug_focus");
    }

    public RecipeType<DebugRecipe> getRecipeType() {
        return TYPE;
    }

    public Component getTitle() {
        return this.localizedName;
    }

    public IDrawable getBackground() {
        return this.background;
    }

    public IDrawable getIcon() {
        return null;
    }

    public void setRecipe(IRecipeLayoutBuilder builder, DebugRecipe recipe, IFocusGroup focuses) {
        IRecipeSlotBuilder inputSlot = (IRecipeSlotBuilder)builder.addSlot(RecipeIngredientRole.INPUT, 0, 0).addItemStacks(List.of(new ItemStack((ItemLike)Items.BUCKET), new ItemStack((ItemLike)Items.WATER_BUCKET), new ItemStack((ItemLike)Items.LAVA_BUCKET), new ItemStack((ItemLike)Items.POWDER_SNOW_BUCKET), new ItemStack((ItemLike)Items.AXOLOTL_BUCKET), new ItemStack((ItemLike)Items.SALMON_BUCKET), new ItemStack((ItemLike)Items.COD_BUCKET), new ItemStack((ItemLike)Items.PUFFERFISH_BUCKET), new ItemStack((ItemLike)Items.TROPICAL_FISH_BUCKET)));
        long bucketVolume = this.platformFluidHelper.bucketVolume();
        IRecipeSlotBuilder outputSlot = (IRecipeSlotBuilder)((IRecipeSlotBuilder)((IRecipeSlotBuilder)builder.addSlot(RecipeIngredientRole.OUTPUT, 20, 0).addItemStack(ItemStack.EMPTY)).addIngredients((IIngredientType)this.platformFluidHelper.getFluidIngredientType(), List.of(this.platformFluidHelper.create((Fluid)Fluids.WATER, bucketVolume), this.platformFluidHelper.create((Fluid)Fluids.LAVA, bucketVolume)))).addItemStacks(List.of(new ItemStack((ItemLike)Items.SNOW_BLOCK), new ItemStack((ItemLike)Items.AXOLOTL_SPAWN_EGG), new ItemStack((ItemLike)Items.SALMON), new ItemStack((ItemLike)Items.COD), new ItemStack((ItemLike)Items.PUFFERFISH), new ItemStack((ItemLike)Items.TROPICAL_FISH)));
        builder.addInvisibleIngredients(RecipeIngredientRole.INPUT).addItemStacks(List.of(new ItemStack((ItemLike)Items.ACACIA_BOAT), new ItemStack((ItemLike)Items.ACACIA_BUTTON), new ItemStack((ItemLike)Items.ACACIA_DOOR), new ItemStack((ItemLike)Items.ACACIA_LOG), new ItemStack((ItemLike)Items.ACACIA_PLANKS), new ItemStack((ItemLike)Items.ACACIA_FENCE), new ItemStack((ItemLike)Items.ACACIA_FENCE_GATE), new ItemStack((ItemLike)Items.ACACIA_LEAVES), new ItemStack((ItemLike)Items.ACACIA_PRESSURE_PLATE)));
        builder.createFocusLink(new IIngredientAcceptor[]{inputSlot, outputSlot});
    }

    public ResourceLocation getRegistryName(DebugRecipe recipe) {
        return recipe.getRegistryName();
    }
}

