/*
 * Decompiled with CFR 0.152.
 */
package mezz.jei.library.gui.recipes.supplier.builder;

import java.util.Collection;
import java.util.List;
import java.util.Optional;
import mezz.jei.api.gui.builder.IRecipeSlotBuilder;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.ingredient.IRecipeSlotRichTooltipCallback;
import mezz.jei.api.gui.ingredient.IRecipeSlotTooltipCallback;
import mezz.jei.api.ingredients.IIngredientRenderer;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.ingredients.ITypedIngredient;
import mezz.jei.api.runtime.IIngredientManager;
import mezz.jei.library.ingredients.SimpleIngredientAcceptor;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.level.material.Fluid;
import org.jetbrains.annotations.Nullable;

public class IngredientSlotBuilder
implements IRecipeSlotBuilder {
    private final SimpleIngredientAcceptor ingredients;

    public IngredientSlotBuilder(IIngredientManager ingredientManager) {
        this.ingredients = new SimpleIngredientAcceptor(ingredientManager);
    }

    public <I> IRecipeSlotBuilder addIngredients(IIngredientType<I> ingredientType, List<@Nullable I> ingredients) {
        this.ingredients.addIngredients((IIngredientType)ingredientType, ingredients);
        return this;
    }

    public <I> IRecipeSlotBuilder addIngredient(IIngredientType<I> ingredientType, I ingredient) {
        this.ingredients.addIngredient((IIngredientType)ingredientType, ingredient);
        return this;
    }

    public IRecipeSlotBuilder addFluidStack(Fluid fluid) {
        this.ingredients.addFluidStack(fluid);
        return this;
    }

    public IRecipeSlotBuilder addFluidStack(Fluid fluid, long amount) {
        this.ingredients.addFluidStack(fluid, amount);
        return this;
    }

    public IRecipeSlotBuilder addFluidStack(Fluid fluid, long amount, CompoundTag tag) {
        this.ingredients.addFluidStack(fluid, amount, tag);
        return this;
    }

    public IRecipeSlotBuilder addIngredientsUnsafe(List<?> ingredients) {
        this.ingredients.addIngredientsUnsafe((List)ingredients);
        return this;
    }

    public IRecipeSlotBuilder addTypedIngredients(List<ITypedIngredient<?>> ingredients) {
        this.ingredients.addTypedIngredients((List)ingredients);
        return this;
    }

    public IRecipeSlotBuilder addOptionalTypedIngredients(List<Optional<ITypedIngredient<?>>> ingredients) {
        this.ingredients.addOptionalTypedIngredients((List)ingredients);
        return this;
    }

    public IRecipeSlotBuilder setStandardSlotBackground() {
        return this;
    }

    public IRecipeSlotBuilder setOutputSlotBackground() {
        return this;
    }

    public IRecipeSlotBuilder setBackground(IDrawable background, int xOffset, int yOffset) {
        return this;
    }

    public IRecipeSlotBuilder setOverlay(IDrawable overlay, int xOffset, int yOffset) {
        return this;
    }

    public IRecipeSlotBuilder setFluidRenderer(long capacity, boolean showCapacity, int width, int height) {
        return this;
    }

    public <T> IRecipeSlotBuilder setCustomRenderer(IIngredientType<T> ingredientType, IIngredientRenderer<T> ingredientRenderer) {
        return this;
    }

    public IRecipeSlotBuilder addTooltipCallback(IRecipeSlotTooltipCallback tooltipCallback) {
        return this;
    }

    public IRecipeSlotBuilder addRichTooltipCallback(IRecipeSlotRichTooltipCallback tooltipCallback) {
        return this;
    }

    public IRecipeSlotBuilder setSlotName(String slotName) {
        return this;
    }

    public Collection<ITypedIngredient<?>> getAllIngredients() {
        return this.ingredients.getAllIngredients();
    }
}

