/*
 * Decompiled with CFR 0.152.
 */
package mezz.jei.library.plugins.vanilla.cooking;

import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.drawable.IDrawableAnimated;
import mezz.jei.api.gui.ingredient.IRecipeSlotsView;
import mezz.jei.api.gui.widgets.IRecipeExtrasBuilder;
import mezz.jei.api.gui.widgets.IRecipeWidget;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.RecipeIngredientRole;
import mezz.jei.api.recipe.category.IRecipeCategory;
import mezz.jei.library.util.RecipeUtil;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.crafting.AbstractCookingRecipe;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;

public abstract class AbstractCookingCategory<T extends AbstractCookingRecipe>
implements IRecipeCategory<T> {
    private final IDrawable background;
    private final IDrawable icon;
    private final Component localizedName;
    protected final IGuiHelper guiHelper;
    protected final int regularCookTime;
    protected final IDrawableAnimated animatedFlame;

    public AbstractCookingCategory(IGuiHelper guiHelper, Block icon, String translationKey, int regularCookTime) {
        this(guiHelper, icon, translationKey, regularCookTime, 82, 54);
    }

    public AbstractCookingCategory(IGuiHelper guiHelper, Block icon, String translationKey, int regularCookTime, int width, int height) {
        this.background = guiHelper.createBlankDrawable(width, height);
        this.regularCookTime = regularCookTime;
        this.icon = guiHelper.createDrawableItemLike((ItemLike)icon);
        this.localizedName = Component.translatable((String)translationKey);
        this.guiHelper = guiHelper;
        this.animatedFlame = guiHelper.createAnimatedRecipeFlame(300);
    }

    public IDrawable getBackground() {
        return this.background;
    }

    public IDrawable getIcon() {
        return this.icon;
    }

    public void draw(T recipe, IRecipeSlotsView recipeSlotsView, GuiGraphics guiGraphics, double mouseX, double mouseY) {
        this.animatedFlame.draw(guiGraphics, 1, 20);
        this.drawExperience(recipe, guiGraphics, 0);
        this.drawCookTime(recipe, guiGraphics, 45);
    }

    protected void drawExperience(T recipe, GuiGraphics guiGraphics, int y) {
        float experience = recipe.getExperience();
        if (experience > 0.0f) {
            MutableComponent experienceString = Component.translatable((String)"gui.jei.category.smelting.experience", (Object[])new Object[]{Float.valueOf(experience)});
            Minecraft minecraft = Minecraft.getInstance();
            Font fontRenderer = minecraft.font;
            int stringWidth = fontRenderer.width((FormattedText)experienceString);
            guiGraphics.drawString(fontRenderer, (Component)experienceString, this.getWidth() - stringWidth, y, -8355712, false);
        }
    }

    protected void drawCookTime(T recipe, GuiGraphics guiGraphics, int y) {
        int cookTime = recipe.getCookingTime();
        if (cookTime > 0) {
            int cookTimeSeconds = cookTime / 20;
            MutableComponent timeString = Component.translatable((String)"gui.jei.category.smelting.time.seconds", (Object[])new Object[]{cookTimeSeconds});
            Minecraft minecraft = Minecraft.getInstance();
            Font fontRenderer = minecraft.font;
            int stringWidth = fontRenderer.width((FormattedText)timeString);
            guiGraphics.drawString(fontRenderer, (Component)timeString, this.getWidth() - stringWidth, y, -8355712, false);
        }
    }

    public Component getTitle() {
        return this.localizedName;
    }

    public void setRecipe(IRecipeLayoutBuilder builder, T recipe, IFocusGroup focuses) {
        builder.addSlot(RecipeIngredientRole.INPUT, 1, 1).setStandardSlotBackground().addIngredients((Ingredient)recipe.getIngredients().get(0));
        builder.addSlot(RecipeIngredientRole.RENDER_ONLY, 1, 37).setStandardSlotBackground();
        builder.addSlot(RecipeIngredientRole.OUTPUT, 61, 19).setOutputSlotBackground().addItemStack(RecipeUtil.getResultItem(recipe));
    }

    public void createRecipeExtras(IRecipeExtrasBuilder acceptor, T recipe, IFocusGroup focuses) {
        acceptor.addWidget(this.createCookingArrowWidget(recipe, 26, 17));
    }

    public boolean isHandled(T recipe) {
        return !recipe.isSpecial();
    }

    public ResourceLocation getRegistryName(T recipe) {
        return recipe.getId();
    }

    protected IRecipeWidget createCookingArrowWidget(T recipe, int x, int y) {
        int cookTime = recipe.getCookingTime();
        if (cookTime <= 0) {
            cookTime = this.regularCookTime;
        }
        IDrawableAnimated recipeArrow = this.guiHelper.createAnimatedRecipeArrow(cookTime);
        return this.guiHelper.createWidgetFromDrawable((IDrawable)recipeArrow, x, y);
    }
}

