/*
 * Decompiled with CFR 0.152.
 */
package mezz.jei.library.gui.widgets;

import java.util.List;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.drawable.IDrawableStatic;
import mezz.jei.api.gui.ingredient.IRecipeSlotDrawable;
import mezz.jei.api.gui.inputs.IJeiInputHandler;
import mezz.jei.api.gui.widgets.IRecipeExtrasBuilder;
import mezz.jei.api.gui.widgets.IRecipeWidget;
import mezz.jei.api.gui.widgets.IScrollGridWidgetFactory;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.common.util.ImmutableSize2i;
import mezz.jei.library.gui.widgets.ScrollGridRecipeWidget;
import net.minecraft.client.gui.navigation.ScreenRectangle;

public class ScrollGridWidgetFactory<R>
implements IScrollGridWidgetFactory<R> {
    private final int columns;
    private final int visibleRows;
    private final IGuiHelper guiHelper;
    private ScreenRectangle area;

    public ScrollGridWidgetFactory(IGuiHelper guiHelper, int columns, int visibleRows) {
        this.guiHelper = guiHelper;
        IDrawableStatic slotBackground = guiHelper.getSlotDrawable();
        this.columns = columns;
        this.visibleRows = visibleRows;
        ImmutableSize2i size = ScrollGridRecipeWidget.calculateSize((IDrawable)slotBackground, columns, visibleRows);
        this.area = new ScreenRectangle(0, 0, size.width(), size.height());
    }

    public void setPosition(int x, int y) {
        this.area = new ScreenRectangle(x, y, this.area.width(), this.area.height());
    }

    public ScreenRectangle getArea() {
        return this.area;
    }

    public void createWidgetForSlots(IRecipeExtrasBuilder builder, R recipe, List<IRecipeSlotDrawable> slots) {
        ScrollGridRecipeWidget widget = new ScrollGridRecipeWidget(this.guiHelper, this.area, this.columns, this.visibleRows, slots);
        builder.addWidget((IRecipeWidget)widget);
        builder.addInputHandler((IJeiInputHandler)widget);
    }
}

