/*
 * Decompiled with CFR 0.152.
 */
package mezz.jei.library.plugins.vanilla.compostable;

import it.unimi.dsi.fastutil.objects.Object2FloatMap;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.ingredients.IIngredientHelper;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.ingredients.subtypes.UidContext;
import mezz.jei.api.recipe.vanilla.IJeiCompostingRecipe;
import mezz.jei.api.runtime.IIngredientManager;
import mezz.jei.library.plugins.vanilla.compostable.CompostingRecipe;
import mezz.jei.library.util.ResourceLocationUtil;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.ComposterBlock;

public class CompostingRecipeMaker {
    public static List<IJeiCompostingRecipe> getRecipes(IIngredientManager ingredientManager) {
        Object2FloatMap compostables = ComposterBlock.COMPOSTABLES;
        Collection allIngredients = ingredientManager.getAllItemStacks();
        IIngredientHelper ingredientHelper = ingredientManager.getIngredientHelper((IIngredientType)VanillaTypes.ITEM_STACK);
        return allIngredients.stream().mapMulti((itemStack, consumer) -> {
            Item item = itemStack.getItem();
            float compostValue = compostables.getOrDefault((Object)item, 0.0f);
            if (compostValue > 0.0f) {
                String ingredientUid = ingredientHelper.getUniqueId(itemStack, UidContext.Recipe);
                String ingredientUidPath = ResourceLocationUtil.sanitizePath(ingredientUid);
                ResourceLocation recipeUid = new ResourceLocation("jei", ingredientUidPath);
                CompostingRecipe recipe = new CompostingRecipe((ItemStack)itemStack, compostValue, recipeUid);
                consumer.accept(recipe);
            }
        }).limit(compostables.size()).sorted(Comparator.comparingDouble(IJeiCompostingRecipe::getChance)).toList();
    }
}

