/*
 * Decompiled with CFR 0.152.
 */
package mezz.jei.library.plugins.debug;

import com.mojang.blaze3d.platform.InputConstants;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import mezz.jei.api.constants.RecipeTypes;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.builder.IRecipeSlotBuilder;
import mezz.jei.api.gui.builder.ITooltipBuilder;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.ingredient.IRecipeSlotTooltipCallback;
import mezz.jei.api.gui.ingredient.IRecipeSlotView;
import mezz.jei.api.gui.ingredient.IRecipeSlotsView;
import mezz.jei.api.gui.inputs.IJeiInputHandler;
import mezz.jei.api.gui.inputs.IJeiUserInput;
import mezz.jei.api.gui.widgets.IRecipeExtrasBuilder;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.helpers.IPlatformFluidHelper;
import mezz.jei.api.ingredients.IIngredientHelper;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.ingredients.IIngredientTypeWithSubtypes;
import mezz.jei.api.ingredients.ITypedIngredient;
import mezz.jei.api.ingredients.subtypes.UidContext;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.IRecipeManager;
import mezz.jei.api.recipe.RecipeIngredientRole;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import mezz.jei.api.runtime.IBookmarkOverlay;
import mezz.jei.api.runtime.IIngredientFilter;
import mezz.jei.api.runtime.IIngredientListOverlay;
import mezz.jei.api.runtime.IIngredientManager;
import mezz.jei.api.runtime.IJeiRuntime;
import mezz.jei.common.Internal;
import mezz.jei.common.gui.JeiTooltip;
import mezz.jei.common.gui.textures.Textures;
import mezz.jei.library.plugins.debug.DebugRecipe;
import mezz.jei.library.plugins.debug.ingredients.DebugIngredient;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.navigation.ScreenRectangle;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.inventory.InventoryScreen;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import org.jetbrains.annotations.Nullable;

public class DebugRecipeCategory<F>
implements IRecipeCategory<DebugRecipe> {
    public static final RecipeType<DebugRecipe> TYPE = RecipeType.create((String)"jei", (String)"debug", DebugRecipe.class);
    public static final int RECIPE_WIDTH = 160;
    public static final int RECIPE_HEIGHT = 60;
    private final IDrawable background;
    private final IPlatformFluidHelper<F> platformFluidHelper;
    private final IIngredientManager ingredientManager;
    private final Component localizedName;
    private final IDrawable tankBackground;
    private final IDrawable tankOverlay;
    private final IDrawable item;
    @Nullable
    private IJeiRuntime runtime;
    private boolean hiddenRecipes;

    public DebugRecipeCategory(IGuiHelper guiHelper, IPlatformFluidHelper<F> platformFluidHelper, IIngredientManager ingredientManager) {
        this.background = guiHelper.createBlankDrawable(160, 60);
        this.platformFluidHelper = platformFluidHelper;
        this.ingredientManager = ingredientManager;
        this.localizedName = Component.literal((String)"debug");
        ResourceLocation backgroundTexture = new ResourceLocation("jei", "textures/jei/gui/debug.png");
        this.tankBackground = guiHelper.createDrawable(backgroundTexture, 220, 196, 18, 60);
        this.tankOverlay = guiHelper.createDrawable(backgroundTexture, 238, 196, 18, 60);
        this.item = guiHelper.createDrawableItemStack(new ItemStack((ItemLike)Items.ACACIA_LEAVES));
    }

    public void setRuntime(IJeiRuntime runtime) {
        this.runtime = runtime;
    }

    public RecipeType<DebugRecipe> getRecipeType() {
        return TYPE;
    }

    public Component getTitle() {
        return this.localizedName;
    }

    public IDrawable getBackground() {
        return this.background;
    }

    public IDrawable getIcon() {
        Textures textures = Internal.getTextures();
        return textures.getConfigButtonIcon();
    }

    public void draw(DebugRecipe recipe, IRecipeSlotsView recipeSlotsView, GuiGraphics guiGraphics, double mouseX, double mouseY) {
        if (this.runtime != null) {
            this.item.draw(guiGraphics, 50, 20);
            IIngredientFilter ingredientFilter = this.runtime.getIngredientFilter();
            Minecraft minecraft = Minecraft.getInstance();
            guiGraphics.drawString(minecraft.font, ingredientFilter.getFilterText(), 20, 52, 0, false);
            IIngredientListOverlay ingredientListOverlay = this.runtime.getIngredientListOverlay();
            Optional<ITypedIngredient<?>> ingredientUnderMouse = DebugRecipeCategory.getIngredientUnderMouse(ingredientListOverlay, this.runtime.getBookmarkOverlay());
            ingredientUnderMouse.ifPresent(typedIngredient -> this.drawIngredientName(minecraft, guiGraphics, (ITypedIngredient)typedIngredient));
        }
        Button button = recipe.getButton();
        button.render(guiGraphics, (int)mouseX, (int)mouseY, 0.0f);
    }

    private static Optional<ITypedIngredient<?>> getIngredientUnderMouse(IIngredientListOverlay ingredientListOverlay, IBookmarkOverlay bookmarkOverlay) {
        return ingredientListOverlay.getIngredientUnderMouse().or(() -> ((IBookmarkOverlay)bookmarkOverlay).getIngredientUnderMouse());
    }

    private <T> void drawIngredientName(Minecraft minecraft, GuiGraphics guiGraphics, ITypedIngredient<T> ingredient) {
        IIngredientHelper ingredientHelper = this.ingredientManager.getIngredientHelper(ingredient.getType());
        String jeiUid = ingredientHelper.getUniqueId(ingredient.getIngredient(), UidContext.Ingredient);
        guiGraphics.drawString(minecraft.font, jeiUid, 50, 52, 0, false);
    }

    public void setRecipe(IRecipeLayoutBuilder builder, DebugRecipe recipe, IFocusGroup focuses) {
        ((IRecipeSlotBuilder)builder.addSlot(RecipeIngredientRole.OUTPUT, 70, 0).addItemStack(new ItemStack((ItemLike)Items.FARMLAND))).addItemStack(new ItemStack((ItemLike)Items.BUNDLE));
        builder.addSlot(RecipeIngredientRole.INPUT, 110, 0).addIngredientsUnsafe(Arrays.asList(new ItemStack((ItemLike)Items.RABBIT), null));
        long bucketVolume = this.platformFluidHelper.bucketVolume();
        IIngredientTypeWithSubtypes fluidType = this.platformFluidHelper.getFluidIngredientType();
        long capacity = 10L * bucketVolume;
        long amount = capacity / 2L + (long)((int)(Math.random() * (double)capacity / 2.0));
        builder.addSlot(RecipeIngredientRole.OUTPUT, 90, 0).setFluidRenderer(capacity, false, 16, 58).setOverlay(this.tankOverlay, -1, -1).setBackground(this.tankBackground, -1, -1).addFluidStack((Fluid)Fluids.WATER, amount);
        capacity = 2L * bucketVolume;
        amount = capacity / 2L + (long)((int)(Math.random() * (double)capacity / 2.0));
        builder.addSlot(RecipeIngredientRole.INPUT, 24, 0).setFluidRenderer(capacity, true, 12, 47).addIngredient((IIngredientType)fluidType, this.platformFluidHelper.create((Fluid)Fluids.LAVA, amount));
        builder.addSlot(RecipeIngredientRole.INPUT, 40, 0).addIngredients(DebugIngredient.TYPE, List.of(new DebugIngredient(0), new DebugIngredient(1)));
        builder.addSlot(RecipeIngredientRole.OUTPUT, 40, 16).addIngredient(DebugIngredient.TYPE, (Object)new DebugIngredient(2));
        ((IRecipeSlotBuilder)((IRecipeSlotBuilder)builder.addSlot(RecipeIngredientRole.INPUT, 40, 32).addIngredient(DebugIngredient.TYPE, (Object)new DebugIngredient(3))).addIngredientsUnsafe(List.of(this.platformFluidHelper.create((Fluid)Fluids.LAVA, (long)((int)((1.0 + Math.random()) * (double)bucketVolume))), new ItemStack((ItemLike)Items.ACACIA_LEAVES)))).addTooltipCallback(new IRecipeSlotTooltipCallback(){

            public void onTooltip(IRecipeSlotView recipeSlotView, List<Component> tooltip) {
                switch (recipeSlotView.getRole()) {
                    case INPUT: {
                        tooltip.add((Component)Component.literal((String)"Input DebugIngredient"));
                        break;
                    }
                    case OUTPUT: {
                        tooltip.add((Component)Component.literal((String)"Output DebugIngredient"));
                        break;
                    }
                    case CATALYST: {
                        tooltip.add((Component)Component.literal((String)"Catalyst DebugIngredient"));
                    }
                }
            }

            public void onRichTooltip(IRecipeSlotView recipeSlotView, ITooltipBuilder tooltip) {
                switch (recipeSlotView.getRole()) {
                    case INPUT: {
                        tooltip.add((FormattedText)Component.literal((String)"Input DebugIngredient"));
                        break;
                    }
                    case OUTPUT: {
                        tooltip.add((FormattedText)Component.literal((String)"Output DebugIngredient"));
                        break;
                    }
                    case CATALYST: {
                        tooltip.add((FormattedText)Component.literal((String)"Catalyst DebugIngredient"));
                    }
                }
            }
        });
    }

    public void createRecipeExtras(IRecipeExtrasBuilder builder, DebugRecipe recipe, IFocusGroup focuses) {
        builder.addInputHandler((IJeiInputHandler)new JeiInputHandler(recipe, new ScreenRectangle(0, 0, 160, 60)));
    }

    public List<Component> getTooltipStrings(DebugRecipe recipe, IRecipeSlotsView recipeSlotsView, double mouseX, double mouseY) {
        JeiTooltip tooltip = new JeiTooltip();
        this.getTooltip((ITooltipBuilder)tooltip, recipe, recipeSlotsView, mouseX, mouseY);
        return tooltip.toLegacyToComponents();
    }

    public void getTooltip(ITooltipBuilder tooltip, DebugRecipe recipe, IRecipeSlotsView recipeSlotsView, double mouseX, double mouseY) {
        tooltip.add((FormattedText)Component.literal((String)"Debug Recipe Category Tooltip is very long and going to wrap").withStyle(ChatFormatting.GOLD));
        if (recipe.checkHover(mouseX, mouseY)) {
            tooltip.add((FormattedText)Component.literal((String)"button tooltip!"));
        } else {
            MutableComponent debug = Component.literal((String)"tooltip debug");
            tooltip.add((FormattedText)debug.withStyle(ChatFormatting.BOLD));
        }
        tooltip.add((FormattedText)Component.literal((String)(mouseX + ", " + mouseY)));
    }

    @Nullable
    public ResourceLocation getRegistryName(DebugRecipe recipe) {
        return recipe.getRegistryName();
    }

    public class JeiInputHandler
    implements IJeiInputHandler {
        private final DebugRecipe recipe;
        private final ScreenRectangle area;

        public JeiInputHandler(DebugRecipe recipe, ScreenRectangle area) {
            this.recipe = recipe;
            this.area = area;
        }

        public ScreenRectangle getArea() {
            return this.area;
        }

        public boolean handleInput(double mouseX, double mouseY, IJeiUserInput userInput) {
            if (!userInput.is(Internal.getKeyMappings().getLeftClick())) {
                return false;
            }
            InputConstants.Key key = userInput.getKey();
            Button button = this.recipe.getButton();
            int mouseButton = key.getValue();
            if (mouseButton == 0 && button.mouseClicked(mouseX, mouseY, mouseButton)) {
                if (!userInput.isSimulate()) {
                    Minecraft minecraft = Minecraft.getInstance();
                    LocalPlayer player = minecraft.player;
                    if (player != null) {
                        InventoryScreen screen = new InventoryScreen((Player)player);
                        minecraft.setScreen((Screen)screen);
                    }
                    if (DebugRecipeCategory.this.runtime != null) {
                        IIngredientFilter ingredientFilter = DebugRecipeCategory.this.runtime.getIngredientFilter();
                        String filterText = ingredientFilter.getFilterText();
                        ingredientFilter.setFilterText(filterText + " test");
                        IRecipeManager recipeManager = DebugRecipeCategory.this.runtime.getRecipeManager();
                        if (!DebugRecipeCategory.this.hiddenRecipes) {
                            recipeManager.hideRecipeCategory(RecipeTypes.CRAFTING);
                            DebugRecipeCategory.this.hiddenRecipes = true;
                        } else {
                            recipeManager.unhideRecipeCategory(RecipeTypes.CRAFTING);
                            DebugRecipeCategory.this.hiddenRecipes = false;
                        }
                    }
                }
                return true;
            }
            return false;
        }
    }
}

