/*
 * Decompiled with CFR 0.152.
 */
package mezz.jei.library.plugins.vanilla.ingredients;

import com.google.common.collect.Streams;
import java.util.Collection;
import java.util.Optional;
import java.util.stream.Stream;
import mezz.jei.api.constants.Tags;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.helpers.IColorHelper;
import mezz.jei.api.ingredients.IIngredientHelper;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.ingredients.subtypes.ISubtypeManager;
import mezz.jei.api.ingredients.subtypes.UidContext;
import mezz.jei.common.Internal;
import mezz.jei.common.config.IClientConfig;
import mezz.jei.common.config.IJeiClientConfigs;
import mezz.jei.common.platform.IPlatformItemStackHelper;
import mezz.jei.common.platform.IPlatformRegistry;
import mezz.jei.common.platform.Services;
import mezz.jei.common.util.ErrorUtil;
import mezz.jei.common.util.StackHelper;
import mezz.jei.common.util.TagUtil;
import net.minecraft.core.DefaultedRegistry;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.Block;
import org.jetbrains.annotations.Nullable;

public class ItemStackHelper
implements IIngredientHelper<ItemStack> {
    private final ISubtypeManager subtypeManager;
    private final StackHelper stackHelper;
    private final IColorHelper colorHelper;
    private final TagKey<Item> itemHiddenFromRecipeViewers;
    private final TagKey<Block> blockHiddenFromRecipeViewers;

    public ItemStackHelper(ISubtypeManager subtypeManager, StackHelper stackHelper, IColorHelper colorHelper) {
        this.subtypeManager = subtypeManager;
        this.stackHelper = stackHelper;
        this.colorHelper = colorHelper;
        this.itemHiddenFromRecipeViewers = new TagKey(Registries.ITEM, Tags.HIDDEN_FROM_RECIPE_VIEWERS);
        this.blockHiddenFromRecipeViewers = new TagKey(Registries.BLOCK, Tags.HIDDEN_FROM_RECIPE_VIEWERS);
    }

    public IIngredientType<ItemStack> getIngredientType() {
        return VanillaTypes.ITEM_STACK;
    }

    public String getDisplayName(ItemStack ingredient) {
        Component displayNameTextComponent = ingredient.getHoverName();
        String displayName = displayNameTextComponent.getString();
        ErrorUtil.checkNotNull((Object)displayName, (String)"itemStack.getDisplayName()");
        return displayName;
    }

    public String getUniqueId(ItemStack ingredient, UidContext context) {
        ErrorUtil.checkNotEmpty((ItemStack)ingredient);
        return this.stackHelper.getUniqueIdentifierForStack(ingredient, context);
    }

    public boolean hasSubtypes(ItemStack ingredient) {
        ErrorUtil.checkNotNull((Object)ingredient, (String)"ingredient");
        return this.subtypeManager.hasSubtypes(VanillaTypes.ITEM_STACK, (Object)ingredient);
    }

    public String getWildcardId(ItemStack ingredient) {
        ErrorUtil.checkNotEmpty((ItemStack)ingredient);
        return StackHelper.getRegistryNameForStack((ItemStack)ingredient);
    }

    public String getDisplayModId(ItemStack ingredient) {
        ErrorUtil.checkNotEmpty((ItemStack)ingredient);
        IPlatformItemStackHelper itemStackHelper = Services.PLATFORM.getItemStackHelper();
        return (String)itemStackHelper.getCreatorModId(ingredient).or(() -> ItemStackHelper.getNamespace(ingredient)).orElseThrow(() -> {
            String stackInfo = this.getErrorInfo(ingredient);
            return new IllegalStateException("null registryName for: " + stackInfo);
        });
    }

    private static Optional<String> getNamespace(ItemStack ingredient) {
        return Services.PLATFORM.getRegistry(Registries.ITEM).getRegistryName((Object)ingredient.getItem()).map(ResourceLocation::getNamespace);
    }

    public long getAmount(ItemStack ingredient) {
        return ingredient.getCount();
    }

    public ItemStack copyWithAmount(ItemStack ingredient, long amount) {
        ItemStack copy = ingredient.copy();
        int intAmount = Math.toIntExact(amount);
        copy.setCount(intAmount);
        return copy;
    }

    public Iterable<Integer> getColors(ItemStack ingredient) {
        return this.colorHelper.getColors(ingredient, 2);
    }

    public ResourceLocation getResourceLocation(ItemStack ingredient) {
        ErrorUtil.checkNotEmpty((ItemStack)ingredient);
        Item item = ingredient.getItem();
        return (ResourceLocation)Services.PLATFORM.getRegistry(Registries.ITEM).getRegistryName((Object)item).orElseThrow(() -> {
            String stackInfo = this.getErrorInfo(ingredient);
            return new IllegalStateException("item has no key in the Item registry: " + stackInfo);
        });
    }

    public ItemStack getCheatItemStack(ItemStack ingredient) {
        return ingredient;
    }

    public ItemStack copyIngredient(ItemStack ingredient) {
        return ingredient.copy();
    }

    public ItemStack normalizeIngredient(ItemStack ingredient) {
        if (ingredient.getCount() == 1) {
            return ingredient;
        }
        int originalCount = ingredient.getCount();
        ingredient.setCount(1);
        ItemStack copy = ingredient.copy();
        ingredient.setCount(originalCount);
        return copy;
    }

    public boolean isValidIngredient(ItemStack ingredient) {
        return !ingredient.isEmpty();
    }

    public boolean isIngredientOnServer(ItemStack ingredient) {
        Item item = ingredient.getItem();
        IPlatformRegistry registry = Services.PLATFORM.getRegistry(Registries.ITEM);
        return registry.contains((Object)item);
    }

    public Stream<ResourceLocation> getTagStream(ItemStack ingredient) {
        Stream<ResourceLocation> itemTagStream = ingredient.getTags().map(TagKey::location);
        Item item = ingredient.getItem();
        if (item instanceof BlockItem) {
            BlockItem blockItem = (BlockItem)item;
            IJeiClientConfigs jeiClientConfigs = Internal.getJeiClientConfigs();
            IClientConfig clientConfig = jeiClientConfigs.getClientConfig();
            if (clientConfig.isLookupBlockTagsEnabled()) {
                Stream<ResourceLocation> blockTagStream = blockItem.getBlock().defaultBlockState().getTags().map(TagKey::location);
                return Streams.concat((Stream[])new Stream[]{itemTagStream, blockTagStream});
            }
        }
        return itemTagStream;
    }

    public boolean isHiddenFromRecipeViewersByTags(ItemStack ingredient) {
        if (ingredient.is(this.itemHiddenFromRecipeViewers)) {
            return true;
        }
        Item item = ingredient.getItem();
        if (item instanceof BlockItem) {
            BlockItem blockItem = (BlockItem)item;
            IJeiClientConfigs jeiClientConfigs = Internal.getJeiClientConfigs();
            IClientConfig clientConfig = jeiClientConfigs.getClientConfig();
            if (clientConfig.isLookupBlockTagsEnabled()) {
                Block block = blockItem.getBlock();
                Holder.Reference holder = block.builtInRegistryHolder();
                return holder.is(this.blockHiddenFromRecipeViewers);
            }
        }
        return false;
    }

    public String getErrorInfo(@Nullable ItemStack ingredient) {
        return ErrorUtil.getItemStackInfo((ItemStack)ingredient);
    }

    public Optional<TagKey<?>> getTagKeyEquivalent(Collection<ItemStack> ingredients) {
        return TagUtil.getTagEquivalent(ingredients, ItemStack::getItem, () -> ((DefaultedRegistry)BuiltInRegistries.ITEM).getTags());
    }
}

