/*
 * Decompiled with CFR 0.152.
 */
package mezz.jei.library.plugins.jei.info;

import java.util.List;
import java.util.Objects;
import mezz.jei.api.constants.RecipeTypes;
import mezz.jei.api.gui.builder.IIngredientAcceptor;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.builder.IRecipeSlotBuilder;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.inputs.IJeiInputHandler;
import mezz.jei.api.gui.widgets.IRecipeExtrasBuilder;
import mezz.jei.api.gui.widgets.IRecipeWidget;
import mezz.jei.api.gui.widgets.IScrollBoxWidget;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.ingredients.ITypedIngredient;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.RecipeIngredientRole;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import mezz.jei.api.recipe.vanilla.IJeiIngredientInfoRecipe;
import mezz.jei.common.gui.textures.Textures;
import mezz.jei.common.util.StringUtil;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.locale.Language;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.FormattedCharSequence;
import org.jetbrains.annotations.Nullable;

public class IngredientInfoRecipeCategory
implements IRecipeCategory<IJeiIngredientInfoRecipe> {
    private static final int recipeWidth = 170;
    private static final int recipeHeight = 125;
    private static final int lineSpacing = 2;
    private final IDrawable background;
    private final IGuiHelper guiHelper;
    private final IDrawable icon;
    private final IDrawable slotBackground;
    private final Component localizedName;

    public IngredientInfoRecipeCategory(IGuiHelper guiHelper, Textures textures) {
        this.background = guiHelper.createBlankDrawable(170, 125);
        this.guiHelper = guiHelper;
        this.icon = textures.getInfoIcon();
        this.slotBackground = guiHelper.getSlotDrawable();
        this.localizedName = Component.translatable((String)"gui.jei.category.itemInformation");
    }

    public RecipeType<IJeiIngredientInfoRecipe> getRecipeType() {
        return RecipeTypes.INFORMATION;
    }

    public Component getTitle() {
        return this.localizedName;
    }

    public IDrawable getIcon() {
        return this.icon;
    }

    public IDrawable getBackground() {
        return this.background;
    }

    public void createRecipeExtras(IRecipeExtrasBuilder builder, IJeiIngredientInfoRecipe recipe, IFocusGroup focuses) {
        int yPos = this.slotBackground.getHeight() + 4;
        int height = 125 - yPos;
        int width = 170 - this.guiHelper.getScrollBoxScrollbarExtraWidth();
        IScrollBoxWidget scrollBoxWidget = this.guiHelper.createScrollBoxWidget((IDrawable)new Contents(recipe, width), height, 0, yPos);
        builder.addWidget((IRecipeWidget)scrollBoxWidget);
        builder.addInputHandler((IJeiInputHandler)scrollBoxWidget);
    }

    public void setRecipe(IRecipeLayoutBuilder builder, IJeiIngredientInfoRecipe recipe, IFocusGroup focuses) {
        int xPos = 77;
        IRecipeSlotBuilder inputSlotBuilder = builder.addSlot(RecipeIngredientRole.INPUT, xPos, 1).setBackground(this.slotBackground, -1, -1);
        IIngredientAcceptor outputSlotBuilder = builder.addInvisibleIngredients(RecipeIngredientRole.OUTPUT);
        for (ITypedIngredient typedIngredient : recipe.getIngredients()) {
            IngredientInfoRecipeCategory.addIngredient(typedIngredient, inputSlotBuilder);
            IngredientInfoRecipeCategory.addIngredient(typedIngredient, outputSlotBuilder);
        }
    }

    @Nullable
    public ResourceLocation getRegistryName(IJeiIngredientInfoRecipe recipe) {
        return null;
    }

    private static <T> void addIngredient(ITypedIngredient<T> typedIngredient, IIngredientAcceptor<?> slotBuilder) {
        slotBuilder.addIngredient(typedIngredient.getType(), typedIngredient.getIngredient());
    }

    private static class Contents
    implements IDrawable {
        private final List<FormattedText> descriptionLines;
        private final int lineHeight;
        private final int width;
        private final int height;

        public Contents(IJeiIngredientInfoRecipe recipe, int width) {
            Minecraft minecraft = Minecraft.getInstance();
            Objects.requireNonNull(minecraft.font);
            this.lineHeight = 9 + 2;
            this.descriptionLines = StringUtil.splitLines((List)recipe.getDescription(), (int)width);
            this.width = width;
            this.height = this.lineHeight * this.descriptionLines.size() - 2;
        }

        public int getWidth() {
            return this.width;
        }

        public int getHeight() {
            return this.height;
        }

        public void draw(GuiGraphics guiGraphics, int xOffset, int yOffset) {
            Language language = Language.getInstance();
            Minecraft minecraft = Minecraft.getInstance();
            Font font = minecraft.font;
            int yPos = 0;
            for (FormattedText descriptionLine : this.descriptionLines) {
                FormattedCharSequence charSequence = language.getVisualOrder(descriptionLine);
                guiGraphics.drawString(font, charSequence, 0, yPos, -16777216, false);
                yPos += this.lineHeight;
            }
        }
    }
}

