/*
 * Decompiled with CFR 0.152.
 */
package mezz.jei.library.recipes;

import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import mezz.jei.api.gui.IRecipeLayoutDrawable;
import mezz.jei.api.gui.drawable.IScalableDrawable;
import mezz.jei.api.gui.ingredient.IRecipeSlotDrawable;
import mezz.jei.api.ingredients.ITypedIngredient;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.IRecipeCatalystLookup;
import mezz.jei.api.recipe.IRecipeCategoriesLookup;
import mezz.jei.api.recipe.IRecipeLookup;
import mezz.jei.api.recipe.IRecipeManager;
import mezz.jei.api.recipe.RecipeIngredientRole;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import mezz.jei.api.runtime.IIngredientManager;
import mezz.jei.common.util.ErrorUtil;
import mezz.jei.core.util.Pair;
import mezz.jei.library.gui.ingredients.CycleTimer;
import mezz.jei.library.gui.ingredients.ICycler;
import mezz.jei.library.gui.recipes.RecipeLayout;
import mezz.jei.library.gui.recipes.layout.builder.RecipeSlotBuilder;
import mezz.jei.library.recipes.RecipeCatalystLookup;
import mezz.jei.library.recipes.RecipeCategoriesLookup;
import mezz.jei.library.recipes.RecipeLookup;
import mezz.jei.library.recipes.RecipeManagerInternal;
import net.minecraft.resources.ResourceLocation;

public class RecipeManager
implements IRecipeManager {
    private final RecipeManagerInternal internal;
    private final IIngredientManager ingredientManager;

    public RecipeManager(RecipeManagerInternal internal, IIngredientManager ingredientManager) {
        this.internal = internal;
        this.ingredientManager = ingredientManager;
    }

    public <R> IRecipeLookup<R> createRecipeLookup(RecipeType<R> recipeType) {
        ErrorUtil.checkNotNull(recipeType, (String)"recipeType");
        return new RecipeLookup<R>(recipeType, this.internal, this.ingredientManager);
    }

    public IRecipeCategoriesLookup createRecipeCategoryLookup() {
        return new RecipeCategoriesLookup(this.internal, this.ingredientManager);
    }

    public <T> IRecipeCategory<T> getRecipeCategory(RecipeType<T> recipeType) {
        return this.internal.getRecipeCategory(recipeType);
    }

    public IRecipeCatalystLookup createRecipeCatalystLookup(RecipeType<?> recipeType) {
        return new RecipeCatalystLookup(recipeType, this.internal);
    }

    public <T> void addRecipes(RecipeType<T> recipeType, List<T> recipes) {
        ErrorUtil.checkNotNull(recipeType, (String)"recipeType");
        ErrorUtil.checkNotNull(recipes, (String)"recipes");
        ErrorUtil.validateRecipes(recipeType, recipes);
        ErrorUtil.assertMainThread();
        this.internal.addRecipes(recipeType, recipes);
    }

    public <T> Optional<IRecipeLayoutDrawable<T>> createRecipeLayoutDrawable(IRecipeCategory<T> recipeCategory, T recipe, IFocusGroup focusGroup) {
        ErrorUtil.checkNotNull(recipeCategory, (String)"recipeCategory");
        ErrorUtil.checkNotNull(recipe, (String)"recipe");
        ErrorUtil.checkNotNull((Object)focusGroup, (String)"focusGroup");
        RecipeType recipeType = recipeCategory.getRecipeType();
        List decorators = this.internal.getRecipeCategoryDecorators(recipeType);
        return RecipeLayout.create(recipeCategory, decorators, recipe, focusGroup, this.ingredientManager);
    }

    public <T> Optional<IRecipeLayoutDrawable<T>> createRecipeLayoutDrawable(IRecipeCategory<T> recipeCategory, T recipe, IFocusGroup focusGroup, IScalableDrawable background, int borderSize) {
        ErrorUtil.checkNotNull(recipeCategory, (String)"recipeCategory");
        ErrorUtil.checkNotNull(recipe, (String)"recipe");
        ErrorUtil.checkNotNull((Object)focusGroup, (String)"focusGroup");
        ErrorUtil.checkNotNull((Object)background, (String)"background");
        RecipeType recipeType = recipeCategory.getRecipeType();
        List decorators = this.internal.getRecipeCategoryDecorators(recipeType);
        return RecipeLayout.create(recipeCategory, decorators, recipe, focusGroup, this.ingredientManager, background, borderSize);
    }

    public IRecipeSlotDrawable createRecipeSlotDrawable(RecipeIngredientRole role, List<Optional<ITypedIngredient<?>>> ingredients, Set<Integer> focusedIngredients, int xPos, int yPos, int ingredientCycleOffset) {
        RecipeSlotBuilder builder = new RecipeSlotBuilder(this.ingredientManager, 0, role, xPos, yPos);
        builder.addOptionalTypedIngredients(ingredients);
        CycleTimer cycleTimer = CycleTimer.create(ingredientCycleOffset);
        Pair<Integer, IRecipeSlotDrawable> result = builder.build(focusedIngredients, (ICycler)cycleTimer);
        return (IRecipeSlotDrawable)result.second();
    }

    public <T> void hideRecipes(RecipeType<T> recipeType, Collection<T> recipes) {
        ErrorUtil.checkNotNull(recipes, (String)"recipe");
        ErrorUtil.checkNotNull(recipeType, (String)"recipeType");
        ErrorUtil.validateRecipes(recipeType, recipes);
        ErrorUtil.assertMainThread();
        this.internal.hideRecipes(recipeType, recipes);
    }

    public <T> void unhideRecipes(RecipeType<T> recipeType, Collection<T> recipes) {
        ErrorUtil.checkNotNull(recipes, (String)"recipe");
        ErrorUtil.checkNotNull(recipeType, (String)"recipeType");
        ErrorUtil.validateRecipes(recipeType, recipes);
        ErrorUtil.assertMainThread();
        this.internal.unhideRecipes(recipeType, recipes);
    }

    public void hideRecipeCategory(RecipeType<?> recipeType) {
        ErrorUtil.checkNotNull(recipeType, (String)"recipeType");
        ErrorUtil.assertMainThread();
        this.internal.hideRecipeCategory(recipeType);
    }

    public void unhideRecipeCategory(RecipeType<?> recipeType) {
        ErrorUtil.checkNotNull(recipeType, (String)"recipeType");
        ErrorUtil.assertMainThread();
        this.internal.unhideRecipeCategory(recipeType);
    }

    public <T> Optional<RecipeType<T>> getRecipeType(ResourceLocation recipeUid, Class<? extends T> recipeClass) {
        return this.internal.getRecipeType(recipeUid, recipeClass);
    }

    public Optional<RecipeType<?>> getRecipeType(ResourceLocation recipeUid) {
        return this.internal.getRecipeType(recipeUid);
    }
}

