/*
 * Decompiled with CFR 0.152.
 */
package mezz.jei.library.plugins.vanilla;

import java.util.List;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.ingredients.IIngredientHelper;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.recipe.vanilla.IJeiAnvilRecipe;
import mezz.jei.api.recipe.vanilla.IJeiBrewingRecipe;
import mezz.jei.api.recipe.vanilla.IVanillaRecipeFactory;
import mezz.jei.api.runtime.IIngredientManager;
import mezz.jei.common.util.ErrorUtil;
import mezz.jei.library.plugins.vanilla.anvil.AnvilRecipe;
import mezz.jei.library.plugins.vanilla.brewing.BrewingRecipeUtil;
import mezz.jei.library.plugins.vanilla.brewing.JeiBrewingRecipe;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;

public class VanillaRecipeFactory
implements IVanillaRecipeFactory {
    private final BrewingRecipeUtil brewingRecipeUtil;

    public VanillaRecipeFactory(IIngredientManager ingredientManager) {
        IIngredientHelper ingredientHelper = ingredientManager.getIngredientHelper((IIngredientType)VanillaTypes.ITEM_STACK);
        this.brewingRecipeUtil = new BrewingRecipeUtil((IIngredientHelper<ItemStack>)ingredientHelper);
    }

    public IJeiAnvilRecipe createAnvilRecipe(ItemStack leftInput, List<ItemStack> rightInputs, List<ItemStack> outputs, ResourceLocation uid) {
        ErrorUtil.checkNotEmpty((ItemStack)leftInput, (String)"leftInput");
        ErrorUtil.checkNotNull(rightInputs, (String)"rightInputs");
        ErrorUtil.checkNotEmpty(outputs, (String)"outputs");
        ErrorUtil.checkNotNull((Object)uid, (String)"uid");
        return new AnvilRecipe(List.of(leftInput), rightInputs, outputs, uid);
    }

    public AnvilRecipe createAnvilRecipe(ItemStack leftInput, List<ItemStack> rightInputs, List<ItemStack> outputs) {
        ErrorUtil.checkNotEmpty((ItemStack)leftInput, (String)"leftInput");
        ErrorUtil.checkNotNull(rightInputs, (String)"rightInputs");
        ErrorUtil.checkNotEmpty(outputs, (String)"outputs");
        return new AnvilRecipe(List.of(leftInput), rightInputs, outputs, null);
    }

    public AnvilRecipe createAnvilRecipe(List<ItemStack> leftInputs, List<ItemStack> rightInputs, List<ItemStack> outputs, ResourceLocation uid) {
        ErrorUtil.checkNotEmpty(leftInputs, (String)"leftInput");
        ErrorUtil.checkNotNull(rightInputs, (String)"rightInputs");
        ErrorUtil.checkNotEmpty(outputs, (String)"outputs");
        ErrorUtil.checkNotNull((Object)uid, (String)"uid");
        return new AnvilRecipe(leftInputs, rightInputs, outputs, uid);
    }

    public AnvilRecipe createAnvilRecipe(List<ItemStack> leftInputs, List<ItemStack> rightInputs, List<ItemStack> outputs) {
        ErrorUtil.checkNotEmpty(leftInputs, (String)"leftInput");
        ErrorUtil.checkNotNull(rightInputs, (String)"rightInputs");
        ErrorUtil.checkNotEmpty(outputs, (String)"outputs");
        return new AnvilRecipe(leftInputs, rightInputs, outputs, null);
    }

    public IJeiBrewingRecipe createBrewingRecipe(List<ItemStack> ingredients, ItemStack potionInput, ItemStack potionOutput, ResourceLocation uid) {
        ErrorUtil.checkNotEmpty(ingredients, (String)"ingredients");
        ErrorUtil.checkNotEmpty((ItemStack)potionInput, (String)"potionInput");
        ErrorUtil.checkNotEmpty((ItemStack)potionOutput, (String)"potionOutput");
        ErrorUtil.checkNotNull((Object)uid, (String)"uid");
        List<ItemStack> potionInputs = List.of(potionInput);
        return new JeiBrewingRecipe(ingredients, potionInputs, potionOutput, uid, this.brewingRecipeUtil);
    }

    public IJeiBrewingRecipe createBrewingRecipe(List<ItemStack> ingredients, ItemStack potionInput, ItemStack potionOutput) {
        ErrorUtil.checkNotEmpty(ingredients, (String)"ingredients");
        ErrorUtil.checkNotEmpty((ItemStack)potionInput, (String)"potionInput");
        ErrorUtil.checkNotEmpty((ItemStack)potionOutput, (String)"potionOutput");
        List<ItemStack> potionInputs = List.of(potionInput);
        return new JeiBrewingRecipe(ingredients, potionInputs, potionOutput, null, this.brewingRecipeUtil);
    }

    public IJeiBrewingRecipe createBrewingRecipe(List<ItemStack> ingredients, List<ItemStack> potionInputs, ItemStack potionOutput, ResourceLocation uid) {
        ErrorUtil.checkNotEmpty(ingredients, (String)"ingredients");
        ErrorUtil.checkNotEmpty(potionInputs, (String)"potionInputs");
        ErrorUtil.checkNotEmpty((ItemStack)potionOutput, (String)"potionOutput");
        ErrorUtil.checkNotNull((Object)uid, (String)"uid");
        return new JeiBrewingRecipe(ingredients, potionInputs, potionOutput, uid, this.brewingRecipeUtil);
    }

    public IJeiBrewingRecipe createBrewingRecipe(List<ItemStack> ingredients, List<ItemStack> potionInputs, ItemStack potionOutput) {
        ErrorUtil.checkNotEmpty(ingredients, (String)"ingredients");
        ErrorUtil.checkNotEmpty(potionInputs, (String)"potionInputs");
        ErrorUtil.checkNotEmpty((ItemStack)potionOutput, (String)"potionOutput");
        return new JeiBrewingRecipe(ingredients, potionInputs, potionOutput, null, this.brewingRecipeUtil);
    }
}

