/*
 * Decompiled with CFR 0.152.
 */
package mezz.jei.library.ingredients.itemStacks;

import java.util.Optional;
import javax.annotation.Nullable;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.ingredients.ITypedIngredient;
import mezz.jei.library.ingredients.itemStacks.NormalizedTypedItemStack;
import net.minecraft.core.Holder;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;

public record TypedItemStack(Holder<Item> itemHolder, @Nullable CompoundTag tag, int count) implements ITypedIngredient<ItemStack>
{
    public static ITypedIngredient<ItemStack> create(ItemStack ingredient) {
        if (ingredient.getCount() == 1) {
            return NormalizedTypedItemStack.create((Holder<Item>)ingredient.getItemHolder(), ingredient.getTag());
        }
        return new TypedItemStack((Holder<Item>)ingredient.getItemHolder(), ingredient.getTag(), ingredient.getCount());
    }

    public ItemStack getIngredient() {
        ItemStack itemStack = new ItemStack(this.itemHolder, this.count);
        if (this.tag != null) {
            itemStack.setTag(this.tag);
        }
        return itemStack;
    }

    public Optional<ItemStack> getItemStack() {
        return Optional.of(this.getIngredient());
    }

    public IIngredientType<ItemStack> getType() {
        return VanillaTypes.ITEM_STACK;
    }

    @Override
    public String toString() {
        return "TypedItemStack{itemHolder=" + this.itemHolder + ", tag=" + this.tag + ", count=" + this.count + "}";
    }
}

