/*
 * Decompiled with CFR 0.152.
 */
package mezz.jei.library.ingredients.itemStacks;

import java.util.Optional;
import javax.annotation.Nullable;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.ingredients.ITypedIngredient;
import mezz.jei.library.ingredients.itemStacks.NormalizedTypedItem;
import mezz.jei.library.ingredients.itemStacks.TypedItemStack;
import net.minecraft.core.Holder;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;

public record NormalizedTypedItemStack(Holder<Item> itemHolder, CompoundTag tag) implements ITypedIngredient<ItemStack>
{
    public static ITypedIngredient<ItemStack> normalize(ITypedIngredient<ItemStack> typedIngredient) {
        if (typedIngredient instanceof NormalizedTypedItemStack) {
            NormalizedTypedItemStack normalized = (NormalizedTypedItemStack)typedIngredient;
            return normalized;
        }
        if (typedIngredient instanceof NormalizedTypedItem) {
            NormalizedTypedItem normalized = (NormalizedTypedItem)typedIngredient;
            return normalized;
        }
        if (typedIngredient instanceof TypedItemStack) {
            TypedItemStack typedItemStack = (TypedItemStack)typedIngredient;
            return NormalizedTypedItemStack.create(typedItemStack.itemHolder(), typedItemStack.tag());
        }
        ItemStack itemStack = (ItemStack)typedIngredient.getIngredient();
        return NormalizedTypedItemStack.create((Holder<Item>)itemStack.getItemHolder(), itemStack.getTag());
    }

    public static ITypedIngredient<ItemStack> create(Holder<Item> itemHolder, @Nullable CompoundTag tag) {
        if (tag == null) {
            return new NormalizedTypedItem(itemHolder);
        }
        return new NormalizedTypedItemStack(itemHolder, tag);
    }

    public static ITypedIngredient<ItemStack> create(ItemStack itemStack) {
        return NormalizedTypedItemStack.create((Holder<Item>)itemStack.getItemHolder(), itemStack.getTag());
    }

    public ItemStack getIngredient() {
        ItemStack itemStack = new ItemStack(this.itemHolder, 1);
        itemStack.setTag(this.tag);
        return itemStack;
    }

    public Optional<ItemStack> getItemStack() {
        return Optional.of(this.getIngredient());
    }

    public IIngredientType<ItemStack> getType() {
        return VanillaTypes.ITEM_STACK;
    }

    @Override
    public String toString() {
        return "NormalizedTypedItemStack{itemHolder=" + this.itemHolder + ", tag=" + this.tag + "}";
    }
}

