package mezz.jei.library.plugins.vanilla.ingredients.subtypes;

import com.google.common.collect.Lists;
import mezz.jei.api.ingredients.subtypes.IIngredientSubtypeInterpreter;
import mezz.jei.api.ingredients.subtypes.UidContext;
import net.minecraft.class_1780;
import net.minecraft.class_1781;
import net.minecraft.class_1799;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2561;
import java.util.ArrayList;
import java.util.List;
import java.util.StringJoiner;

public class FireworkRocketSubtypeInterpreter implements IIngredientSubtypeInterpreter<class_1799> {
	public static final FireworkRocketSubtypeInterpreter INSTANCE = new FireworkRocketSubtypeInterpreter();

	private FireworkRocketSubtypeInterpreter() {

	}

	@Override
	public String apply(class_1799 itemStack, UidContext context) {
		class_2487 compoundtag = itemStack.method_7941("Fireworks");
		if (compoundtag == null) {
			return IIngredientSubtypeInterpreter.NONE;
		}
		int flightDuration = 0;
		if (compoundtag.method_10573("Flight", 99)) {
			flightDuration = compoundtag.method_10571("Flight");
		}

		List<String> strings = new ArrayList<>();

		class_2499 listtag = compoundtag.method_10554("Explosions", 10);
		if (!listtag.isEmpty()) {
			for (int i = 0; i < listtag.size(); ++i) {
				class_2487 compoundtag1 = listtag.method_10602(i);
				List<class_2561> list = Lists.newArrayList();
				class_1780.method_7809(compoundtag1, list);
				class_1781.class_1782 shape = class_1781.class_1782.method_7813(compoundtag1.method_10571("Type"));
				strings.add(shape.method_7812());
			}
		}

		StringJoiner joiner = new StringJoiner(",", "[", "]");
		strings.sort(null);
		for (String s : strings) {
			joiner.add(s);
		}

		return flightDuration + ":" + joiner;
	}
}
