package mezz.jei.gui.recipes;

import mezz.jei.api.gui.IRecipeLayoutDrawable;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.ingredient.IRecipeSlotsView;
import mezz.jei.api.recipe.transfer.IRecipeTransferError;
import mezz.jei.api.recipe.transfer.IRecipeTransferManager;
import mezz.jei.common.Internal;
import mezz.jei.common.gui.JeiTooltip;
import mezz.jei.common.gui.textures.Textures;
import mezz.jei.common.transfer.RecipeTransferErrorInternal;
import mezz.jei.common.transfer.RecipeTransferUtil;
import mezz.jei.gui.elements.GuiIconToggleButton;
import mezz.jei.gui.input.UserInput;
import net.minecraft.class_1657;
import net.minecraft.class_1703;
import net.minecraft.class_1921;
import net.minecraft.class_2561;
import net.minecraft.class_332;
import net.minecraft.class_437;
import net.minecraft.class_4587;
import net.minecraft.class_768;
import org.jetbrains.annotations.Nullable;

public class RecipeTransferButton extends GuiIconToggleButton {
	public static RecipeTransferButton create(
		IRecipeLayoutDrawable<?> recipeLayout,
		Runnable onClose
	) {
		class_768 buttonArea = recipeLayout.getRecipeTransferButtonArea();
		class_768 layoutArea = recipeLayout.getRect();
		buttonArea.method_35778(buttonArea.method_3321() + layoutArea.method_3321());
		buttonArea.method_35781(buttonArea.method_3322() + layoutArea.method_3322());

		Textures textures = Internal.getTextures();
		IDrawable icon = textures.getRecipeTransfer();
		RecipeTransferButton transferButton = new RecipeTransferButton(icon, recipeLayout, onClose);
		transferButton.updateBounds(buttonArea);
		return transferButton;
	}

	private final IRecipeLayoutDrawable<?> recipeLayout;
	private final Runnable onClose;
	private @Nullable IRecipeTransferError recipeTransferError;
	private @Nullable class_1703 parentContainer;
	private @Nullable class_1657 player;
	private boolean initialized = false;

	private RecipeTransferButton(IDrawable icon, IRecipeLayoutDrawable<?> recipeLayout, Runnable onClose) {
		super(icon, icon);
		this.recipeLayout = recipeLayout;
		this.onClose = onClose;
	}

	public void update(@Nullable class_1703 parentContainer, @Nullable class_1657 player) {
		this.player = player;
		this.parentContainer = parentContainer;
		this.initialized = true;

		if (parentContainer != null && player != null) {
			IRecipeTransferManager recipeTransferManager = Internal.getJeiRuntime().getRecipeTransferManager();
			this.recipeTransferError = RecipeTransferUtil.getTransferRecipeError(recipeTransferManager, parentContainer, recipeLayout, player)
				.orElse(null);
		} else {
			this.recipeTransferError = RecipeTransferErrorInternal.INSTANCE;
		}

		if (recipeTransferError == null ||
			recipeTransferError.getType().allowsTransfer) {
			this.button.field_22763 = true;
			this.button.field_22764 = true;
		} else {
			this.button.field_22763 = false;
			IRecipeTransferError.Type type = this.recipeTransferError.getType();
			this.button.field_22764 = (type == IRecipeTransferError.Type.USER_FACING);
		}
	}

	@Override
	protected boolean onMouseClicked(UserInput input) {
		if (!input.isSimulate()) {
			IRecipeTransferManager recipeTransferManager = Internal.getJeiRuntime().getRecipeTransferManager();
			boolean maxTransfer = class_437.method_25442();
			if (parentContainer != null && player != null && RecipeTransferUtil.transferRecipe(recipeTransferManager, parentContainer, recipeLayout, player, maxTransfer)) {
				onClose.run();
			}
		}
		return true;
	}

	@Override
	protected void getTooltips(JeiTooltip tooltip) {
		if (recipeTransferError == null) {
			class_2561 tooltipTransfer = class_2561.method_43471("jei.tooltip.transfer");
			tooltip.add(tooltipTransfer);
		} else {
			recipeTransferError.getTooltip(tooltip);
		}
	}

	@Override
	protected boolean isIconToggledOn() {
		return false;
	}

	@Override
	public void draw(class_332 guiGraphics, int mouseX, int mouseY, float partialTicks) {
		super.draw(guiGraphics, mouseX, mouseY, partialTicks);
		IRecipeTransferError recipeTransferError = this.recipeTransferError;
		if (recipeTransferError != null) {
			if (recipeTransferError.getType() == IRecipeTransferError.Type.COSMETIC) {
				guiGraphics.method_51739(
					class_1921.method_51785(),
					this.button.method_46426(),
					this.button.method_46427(),
					this.button.method_46426() + this.button.method_25368(),
					this.button.method_46427() + this.button.method_25364(),
					recipeTransferError.getButtonHighlightColor()
				);
			}
			if (isMouseOver(mouseX, mouseY)) {
				IRecipeSlotsView recipeSlotsView = recipeLayout.getRecipeSlotsView();
				class_768 recipeRect = recipeLayout.getRect();
				class_4587 poseStack = guiGraphics.method_51448();
				poseStack.method_22903();
				{
					recipeTransferError.showError(guiGraphics, mouseX, mouseY, recipeSlotsView, recipeRect.method_3321(), recipeRect.method_3322());
				}
				poseStack.method_22909();
			}
		}
	}

	public boolean isInitialized() {
		return initialized;
	}

	public int getMissingCountHint() {
		if (!initialized) {
			return -1;
		}
		if (recipeTransferError == null) {
			return 0;
		}
		return recipeTransferError.getMissingCountHint();
	}
}
