package mezz.jei.common.network.packets.handlers;

import mezz.jei.common.Internal;
import mezz.jei.common.network.ClientPacketContext;
import mezz.jei.common.util.ChatUtil;
import net.minecraft.class_124;
import net.minecraft.class_746;
import mezz.jei.common.config.IServerConfig;
import mezz.jei.common.config.IClientToggleState;
import java.util.ArrayList;
import java.util.List;

/**
 * Client-side-only functions related to cheat permissions
 */
public class ClientCheatPermissionHandler {
	public static void handleHasCheatPermission(ClientPacketContext context, boolean hasPermission) {
		if (!hasPermission) {
			class_746 player = context.player();
			ChatUtil.writeChatMessage(player, "jei.chat.error.no.cheat.permission.1", class_124.field_1061);

			IServerConfig serverConfig = context.serverConfig();
			List<String> allowedCheatingMethods = new ArrayList<>();
			if (serverConfig.isCheatModeEnabledForOp()) {
				allowedCheatingMethods.add("jei.chat.error.no.cheat.permission.op");
			}
			if (serverConfig.isCheatModeEnabledForCreative()) {
				allowedCheatingMethods.add("jei.chat.error.no.cheat.permission.creative");
			}
			if (serverConfig.isCheatModeEnabledForGive()) {
				allowedCheatingMethods.add("jei.chat.error.no.cheat.permission.give");
			}

			if (allowedCheatingMethods.isEmpty()) {
				ChatUtil.writeChatMessage(player, "jei.chat.error.no.cheat.permission.disabled", class_124.field_1061);
			} else {
				ChatUtil.writeChatMessage(player, "jei.chat.error.no.cheat.permission.enabled", class_124.field_1061);
				for (String allowedCheatingMethod : allowedCheatingMethods) {
					ChatUtil.writeChatMessage(player, allowedCheatingMethod, class_124.field_1061);
				}
			}

			IClientToggleState toggleState = Internal.getClientToggleState();
			toggleState.setCheatItemsEnabled(false);
			player.method_7346();
		}
	}
}
