/*
 * Decompiled with CFR 0.152.
 */
package mezz.jei.library.gui.widgets;

import java.util.List;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.inputs.IJeiInputHandler;
import mezz.jei.api.gui.widgets.IScrollBoxWidget;
import mezz.jei.common.Internal;
import mezz.jei.common.config.IClientConfig;
import mezz.jei.common.config.IJeiClientConfigs;
import mezz.jei.common.gui.elements.DrawableBlank;
import mezz.jei.common.gui.elements.DrawableWrappedText;
import mezz.jei.common.util.ImmutableRect2i;
import mezz.jei.common.util.MathUtil;
import mezz.jei.library.gui.widgets.AbstractScrollWidget;
import net.minecraft.class_332;
import net.minecraft.class_4587;
import net.minecraft.class_5348;
import net.minecraft.class_8030;
import org.joml.Matrix4f;

public class ScrollBoxRecipeWidget
extends AbstractScrollWidget
implements IScrollBoxWidget,
IJeiInputHandler {
    private IDrawable contents = DrawableBlank.EMPTY;

    public ScrollBoxRecipeWidget(int width, int height, int xPos, int yPos) {
        super(new ImmutableRect2i(xPos, yPos, width, height));
    }

    @Override
    public int getContentAreaWidth() {
        return this.contentsArea.width();
    }

    @Override
    public int getContentAreaHeight() {
        return this.contentsArea.height();
    }

    @Override
    public IScrollBoxWidget setContents(IDrawable contents) {
        this.contents = contents;
        return this;
    }

    @Override
    public IScrollBoxWidget setContents(List<class_5348> text) {
        this.contents = new DrawableWrappedText(text, this.getContentAreaWidth());
        return this;
    }

    @Override
    protected int getVisibleAmount() {
        return this.contentsArea.height();
    }

    @Override
    protected int getHiddenAmount() {
        return Math.max(this.contents.getHeight() - this.contentsArea.height(), 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void drawContents(class_332 guiGraphics, double mouseX, double mouseY, float scrollOffsetY) {
        class_4587 poseStack = guiGraphics.method_51448();
        class_4587.class_4665 last = poseStack.method_23760();
        Matrix4f pose = last.method_23761();
        class_8030 scissorArea = MathUtil.transform(this.contentsArea, pose);
        guiGraphics.method_44379(scissorArea.method_49620(), scissorArea.method_49618(), scissorArea.method_49621(), scissorArea.method_49619());
        poseStack.method_22903();
        float scrollAmount = (float)this.getHiddenAmount() * scrollOffsetY;
        poseStack.method_22904(0.0, (double)(-scrollAmount), 0.0);
        try {
            this.contents.draw(guiGraphics);
        }
        finally {
            poseStack.method_22909();
            guiGraphics.method_44380();
        }
    }

    @Override
    protected float calculateScrollAmount(double scrollDeltaY) {
        IJeiClientConfigs jeiClientConfigs = Internal.getJeiClientConfigs();
        IClientConfig clientConfig = jeiClientConfigs.getClientConfig();
        int smoothScrollRate = clientConfig.getSmoothScrollRate();
        int totalHeight = this.contents.getHeight();
        double scrollAmount = scrollDeltaY * (double)smoothScrollRate;
        return (float)(scrollAmount / (double)totalHeight);
    }
}

