/*
 * Decompiled with CFR 0.152.
 */
package mezz.jei.fabric.input;

import de.siphalor.amecs.api.KeyModifier;
import de.siphalor.amecs.api.KeyModifiers;
import java.util.ArrayList;
import java.util.List;
import mezz.jei.common.input.keys.JeiKeyModifier;

public class AmecsHelper {
    private AmecsHelper() {
    }

    public static KeyModifier getJeiModifier(JeiKeyModifier modifier) {
        return switch (modifier) {
            default -> throw new IncompatibleClassChangeError();
            case JeiKeyModifier.CONTROL_OR_COMMAND -> KeyModifier.CONTROL;
            case JeiKeyModifier.SHIFT -> KeyModifier.SHIFT;
            case JeiKeyModifier.ALT -> KeyModifier.ALT;
            case JeiKeyModifier.NONE -> KeyModifier.NONE;
        };
    }

    public static List<JeiKeyModifier> getJeiModifiers(KeyModifiers modifiers) {
        if (modifiers.isUnset()) {
            return List.of(JeiKeyModifier.NONE);
        }
        ArrayList<JeiKeyModifier> modifiersList = new ArrayList<JeiKeyModifier>();
        if (modifiers.getAlt()) {
            modifiersList.add(JeiKeyModifier.ALT);
        }
        if (modifiers.getControl()) {
            modifiersList.add(JeiKeyModifier.CONTROL_OR_COMMAND);
        }
        if (modifiers.getShift()) {
            modifiersList.add(JeiKeyModifier.SHIFT);
        }
        return modifiersList;
    }
}

