package mezz.jei.gui.input;

import com.google.common.base.MoreObjects;
import mezz.jei.api.gui.inputs.IJeiUserInput;
import mezz.jei.api.runtime.IJeiKeyMapping;
import mezz.jei.common.input.KeyNameUtil;
import mezz.jei.common.platform.IPlatformInputHelper;
import mezz.jei.common.platform.Services;
import net.minecraft.class_155;
import net.minecraft.class_304;
import net.minecraft.class_3675;
import java.util.Optional;

public class UserInput implements IJeiUserInput {
	@FunctionalInterface
	public interface KeyPressable {
		boolean keyPressed(int keyCode, int scanCode, int modifiers);
	}

	@FunctionalInterface
	public interface MouseClickable {
		boolean mouseClicked(double mouseX, double mouseY, int mouseButton);
	}

	public static UserInput fromVanilla(int keyCode, int scanCode, int modifiers, InputType inputType) {
		class_3675.class_306 input = class_3675.method_15985(keyCode, scanCode);
		return new UserInput(input, MouseUtil.getX(), MouseUtil.getY(), modifiers, inputType);
	}

	public static Optional<UserInput> fromVanilla(double mouseX, double mouseY, int mouseButton, InputType inputType) {
		if (mouseButton < 0) {
			return Optional.empty();
		}
		class_3675.class_306 input = class_3675.class_307.field_1672.method_1447(mouseButton);
		UserInput userInput = new UserInput(input, mouseX, mouseY, 0, inputType);
		return Optional.of(userInput);
	}

	private final class_3675.class_306 key;
	private final double mouseX;
	private final double mouseY;
	private final int modifiers;
	private final InputType inputType;

	public UserInput(class_3675.class_306 key, double mouseX, double mouseY, int modifiers, InputType inputType) {
		this.key = key;
		this.mouseX = mouseX;
		this.mouseY = mouseY;
		this.modifiers = modifiers;
		this.inputType = inputType;
	}

	@Override
	public class_3675.class_306 getKey() {
		return key;
	}

	public double getMouseX() {
		return mouseX;
	}

	public double getMouseY() {
		return mouseY;
	}

	public InputType getInputType() {
		return inputType;
	}

	@Override
	public int getModifiers() {
		return modifiers;
	}

	@Override
	public boolean isSimulate() {
		return inputType == InputType.SIMULATE;
	}

	private boolean isKeyboard() {
		return this.key.method_1442() == class_3675.class_307.field_1668;
	}

	public boolean isAllowedChatCharacter() {
		return isKeyboard() && class_155.method_643((char) this.key.method_1444());
	}

	@Override
	public boolean is(IJeiKeyMapping keyMapping) {
		return keyMapping.isActiveAndMatches(this.key);
	}

	@Override
	public boolean is(class_304 keyMapping) {
		IPlatformInputHelper inputHelper = Services.PLATFORM.getInputHelper();
		return inputHelper.isActiveAndMatches(keyMapping, this.key);
	}

	public boolean callVanilla(IMouseOverable mouseOverable, MouseClickable mouseClickable) {
		if (this.key.method_1442() == class_3675.class_307.field_1672) {
			if (mouseOverable.isMouseOver(mouseX, mouseY)) {
				if (this.isSimulate()) {
					// we can't easily simulate the click, just say we could handle it
					return true;
				}
				return mouseClickable.mouseClicked(mouseX, mouseY, this.key.method_1444());
			}
		}
		return false;
	}

	public boolean callVanilla(KeyPressable keyPressable) {
		if (this.key.method_1442() == class_3675.class_307.field_1668) {
			if (this.isSimulate()) {
				// key press simulate happens on key up, which we ignore
				return false;
			}
			return keyPressable.keyPressed(this.key.method_1444(), 0, this.modifiers);
		}
		return false;
	}

	public boolean callVanilla(IMouseOverable mouseOverable, MouseClickable mouseClickable, KeyPressable keyPressable) {
		return switch (this.key.method_1442()) {
			case field_1668 -> callVanilla(keyPressable);
			case field_1672 -> callVanilla(mouseOverable, mouseClickable);
			default -> false;
		};
	}

	@Override
	public String toString() {
		return MoreObjects.toStringHelper(this)
			.add("inputType", inputType)
			.add("key", KeyNameUtil.getKeyDisplayName(key).getString())
			.add("modifiers", modifiers)
			.add("mouse", String.format("%s, %s", mouseX, mouseY))
			.toString();
	}
}
