package mezz.jei.fabric.input;

import mezz.jei.common.input.keys.JeiKeyConflictContext;
import net.fabricmc.fabric.api.client.keybinding.v1.KeyBindingHelper;
import net.minecraft.class_2561;
import net.minecraft.class_304;
import net.minecraft.class_3675;

public class FabricKeyMapping extends class_304 {
	protected class_3675.class_306 realKey;
	protected final JeiKeyConflictContext context;

	public FabricKeyMapping(
		String description,
		class_3675.class_307 type,
		int keyCode,
		String category,
		JeiKeyConflictContext context
	) {
		// Ensure the default key is set correctly (it is final).
		super(description, type, keyCode, category);
		this.realKey = KeyBindingHelper.getBoundKeyOf(this);
		this.context = context;
		// Overwrite the parent's key variable so it doesn't block other keybinds.
		super.method_1422(class_3675.field_16237);
	}

	// Override all methods that would otherwise interact with super.key so displaying
	// and rebinding work correctly. This cannot work for the static methods that
	// count clicks and monitor presses, but JEI doesn't use them anyway.

	@Override
	public void method_1422(class_3675.class_306 key) {
		this.realKey = key;
	}

	@Override
	public boolean method_1435(class_304 binding) {
		// Special implementation which is aware of the key conflict context.
		if (binding instanceof FabricKeyMapping other) {
			return realKey.equals(KeyBindingHelper.getBoundKeyOf(other)) &&
				(context.conflicts(other.context) || other.context.conflicts(context));
		} else {
			// This ensures symmetry between conflicts, as regular keybinds see this one as
			// being unbound and not conflicting.
			return false;
		}
	}

	@Override
	public boolean method_1415() {
		return this.realKey.equals(class_3675.field_16237);
	}

	@Override
	public boolean method_1417(int keyCode, int scanCode) {
		if (keyCode != class_3675.field_16237.method_1444()) {
			return this.realKey.method_1442() == class_3675.class_307.field_1668 &&
				this.realKey.method_1444() == keyCode;
		} else {
			return this.realKey.method_1442() == class_3675.class_307.field_1671 &&
				this.realKey.method_1444() == scanCode;
		}
	}

	@Override
	public boolean method_1433(int button) {
		return this.realKey.method_1442() == class_3675.class_307.field_1672 &&
			this.realKey.method_1444() == button;
	}

	@Override
	public class_2561 method_16007() {
		return this.realKey.method_27445();
	}

	@Override
	public boolean method_1427() {
		return this.realKey.equals(method_1429());
	}

	@Override
	public String method_1428() {
		return this.realKey.method_1441();
	}
}
