package mezz.jei.common.network.packets;

import io.netty.buffer.Unpooled;
import mezz.jei.common.network.IPacketId;
import net.minecraft.class_2540;
import org.apache.commons.lang3.tuple.Pair;

public abstract class PacketJei {
	public final Pair<class_2540, Integer> getPacketData() {
		IPacketId packetId = getPacketId();
		int packetIdOrdinal = packetId.ordinal();
		class_2540 packetBuffer = new class_2540(Unpooled.buffer());
		packetBuffer.writeByte(packetIdOrdinal);
		writePacketData(packetBuffer);
		return Pair.of(packetBuffer, packetIdOrdinal);
	}

	protected abstract IPacketId getPacketId();

	protected abstract void writePacketData(class_2540 buf);
}
