/*
 * Decompiled with CFR 0.152.
 */
package mezz.jei.library.plugins.debug;

import java.util.ArrayList;
import java.util.List;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.gui.handlers.IGhostIngredientHandler;
import mezz.jei.api.ingredients.IIngredientHelper;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.ingredients.ITypedIngredient;
import mezz.jei.api.runtime.IIngredientManager;
import mezz.jei.common.platform.IPlatformScreenHelper;
import mezz.jei.common.platform.Services;
import net.minecraft.class_1735;
import net.minecraft.class_465;
import net.minecraft.class_768;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class DebugGhostIngredientHandlerTwo<T extends class_465<?>>
implements IGhostIngredientHandler<T> {
    private static final Logger LOGGER = LogManager.getLogger();
    private final IIngredientManager ingredientManager;

    public DebugGhostIngredientHandlerTwo(IIngredientManager ingredientManager) {
        this.ingredientManager = ingredientManager;
    }

    @Override
    public <I> List<IGhostIngredientHandler.Target<I>> getTargetsTyped(T gui, ITypedIngredient<I> typedIngredient, boolean doStart) {
        ArrayList targets = new ArrayList();
        targets.add(new DebugInfoTarget("Got an Ingredient", new class_768(40, 40, 20, 20), this.ingredientManager));
        if (doStart) {
            IIngredientType<I> ingredientType = typedIngredient.getType();
            IIngredientHelper<I> ingredientHelper = this.ingredientManager.getIngredientHelper(ingredientType);
            LOGGER.info("2: Ghost Ingredient Handler Two Starting with {}", (Object)ingredientHelper.getErrorInfo(typedIngredient.getIngredient()));
            targets.add(new DebugInfoTarget("Got an Ingredient", new class_768(30, 30, 20, 20), this.ingredientManager));
        }
        typedIngredient.getIngredient(VanillaTypes.ITEM_STACK).ifPresent(itemStack -> {
            boolean odd = false;
            int count = 0;
            IPlatformScreenHelper screenHelper = Services.PLATFORM.getScreenHelper();
            for (class_1735 slot : gui.method_17577().field_7761) {
                if (odd && count > 10) {
                    int guiLeft = screenHelper.getGuiLeft((class_465<?>)gui);
                    int guiTop = screenHelper.getGuiTop((class_465<?>)gui);
                    class_768 area = new class_768(guiLeft + slot.field_7873, guiTop + slot.field_7872, 16, 16);
                    targets.add(new DebugInfoTarget("Got an Ingredient in Gui", area, this.ingredientManager));
                }
                ++count;
                odd = !odd;
            }
        });
        return targets;
    }

    @Override
    public void onComplete() {
        LOGGER.info("2: Ghost Ingredient Handling Complete");
    }

    private record DebugInfoTarget<I>(String message, class_768 rectangle, IIngredientManager ingredientManager) implements IGhostIngredientHandler.Target<I>
    {
        @Override
        public class_768 getArea() {
            return this.rectangle;
        }

        @Override
        public void accept(I ingredient) {
            IIngredientType<I> ingredientType = this.ingredientManager.getIngredientTypeChecked(ingredient).orElseThrow();
            IIngredientHelper<I> ingredientHelper = this.ingredientManager.getIngredientHelper(ingredientType);
            LOGGER.info("2: {}: {}", (Object)this.message, (Object)ingredientHelper.getErrorInfo(ingredient));
        }
    }
}

