package mezz.jei.library.plugins.vanilla.anvil;

import mezz.jei.api.gui.builder.IIngredientAcceptor;
import mezz.jei.api.recipe.category.extensions.vanilla.smithing.ISmithingCategoryExtension;
import mezz.jei.common.platform.IPlatformRecipeHelper;
import mezz.jei.library.util.RecipeUtil;
import net.minecraft.class_1263;
import net.minecraft.class_1277;
import net.minecraft.class_1799;
import net.minecraft.class_1856;
import net.minecraft.class_8059;
import java.util.Arrays;
import java.util.List;

public abstract class SmithingCategoryExtension<R extends class_8059> implements ISmithingCategoryExtension<R> {
	private final IPlatformRecipeHelper recipeHelper;

	public SmithingCategoryExtension(IPlatformRecipeHelper recipeHelper) {
		this.recipeHelper = recipeHelper;
	}

	@Override
	public <T extends IIngredientAcceptor<T>> void setTemplate(R recipe, T ingredientAcceptor) {
		class_1856 ingredient = recipeHelper.getTemplate(recipe);
		ingredientAcceptor.addIngredients(ingredient);
	}

	@Override
	public <T extends IIngredientAcceptor<T>> void setBase(R recipe, T ingredientAcceptor) {
		class_1856 ingredient = recipeHelper.getBase(recipe);
		ingredientAcceptor.addIngredients(ingredient);
	}

	@Override
	public <T extends IIngredientAcceptor<T>> void setAddition(R recipe, T ingredientAcceptor) {
		class_1856 ingredient = recipeHelper.getAddition(recipe);
		ingredientAcceptor.addIngredients(ingredient);
	}

	@Override
	public <T extends IIngredientAcceptor<T>> void setOutput(R recipe, T ingredientAcceptor) {
		class_1856 templateIngredient = recipeHelper.getTemplate(recipe);
		class_1856 baseIngredient = recipeHelper.getBase(recipe);
		class_1856 additionIngredient = recipeHelper.getAddition(recipe);

		List<class_1799> templateStacks = Arrays.asList(templateIngredient.method_8105());
		if (templateStacks.isEmpty()) {
			templateStacks = List.of(class_1799.field_8037);
		}
		List<class_1799> baseStacks = Arrays.asList(baseIngredient.method_8105());
		if (baseStacks.isEmpty()) {
			baseStacks = List.of(class_1799.field_8037);
		}
		class_1799 addition = class_1799.field_8037;

		class_1799[] additions = additionIngredient.method_8105();
		if (additions.length > 0) {
			addition = additions[0];
		}

		for (class_1799 template : templateStacks) {
			for (class_1799 base : baseStacks) {
				class_1263 recipeInput = createInput(template, base, addition);
				class_1799 output = RecipeUtil.assembleResultItem(recipeInput, recipe);
				ingredientAcceptor.addItemStack(output);
			}
		}
	}

	private static class_1263 createInput(class_1799 template, class_1799 base, class_1799 addition) {
		class_1263 container = new class_1277(3);
		container.method_5447(0, template);
		container.method_5447(1, base);
		container.method_5447(2, addition);
		return container;
	}
}
