/*
 * Decompiled with CFR 0.152.
 */
package mezz.jei.library.recipes;

import com.google.common.collect.ImmutableTable;
import java.util.Optional;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import mezz.jei.api.recipe.transfer.IRecipeTransferHandler;
import mezz.jei.api.recipe.transfer.IRecipeTransferManager;
import mezz.jei.common.Constants;
import mezz.jei.common.util.ErrorUtil;
import net.minecraft.class_1703;
import net.minecraft.class_3917;
import org.jetbrains.annotations.Nullable;

public class RecipeTransferManager
implements IRecipeTransferManager {
    private final ImmutableTable<Class<? extends class_1703>, RecipeType<?>, IRecipeTransferHandler<?, ?>> recipeTransferHandlers;

    public RecipeTransferManager(ImmutableTable<Class<? extends class_1703>, RecipeType<?>, IRecipeTransferHandler<?, ?>> recipeTransferHandlers) {
        this.recipeTransferHandlers = recipeTransferHandlers;
    }

    @Override
    public <C extends class_1703, R> Optional<IRecipeTransferHandler<C, R>> getRecipeTransferHandler(C container, IRecipeCategory<R> recipeCategory) {
        ErrorUtil.checkNotNull(container, "container");
        ErrorUtil.checkNotNull(recipeCategory, "recipeCategory");
        class_3917<C> menuType = this.getMenuType(container);
        RecipeType<R> recipeType = recipeCategory.getRecipeType();
        Class<?> containerClass = container.getClass();
        Optional<IRecipeTransferHandler<C, R>> handler = this.getHandler(containerClass, menuType, recipeType);
        if (handler.isPresent()) {
            return handler;
        }
        return this.getHandler(containerClass, menuType, Constants.UNIVERSAL_RECIPE_TRANSFER_TYPE);
    }

    @Nullable
    private <C extends class_1703> class_3917<C> getMenuType(C container) {
        try {
            class_3917 cast = container.method_17358();
            return cast;
        }
        catch (UnsupportedOperationException ignored) {
            return null;
        }
    }

    private <C extends class_1703, R> Optional<IRecipeTransferHandler<C, R>> getHandler(Class<? extends C> containerClass, @Nullable class_3917<C> menuType, RecipeType<?> recipeType) {
        return Optional.ofNullable((IRecipeTransferHandler)this.recipeTransferHandlers.get(containerClass, recipeType)).filter(handler -> {
            Optional handlerMenuType = handler.getMenuType();
            return handlerMenuType.isEmpty() || handlerMenuType.get().equals(menuType);
        }).flatMap(handler -> {
            IRecipeTransferHandler cast = handler;
            return Optional.of(cast);
        });
    }
}

