package mezz.jei.library.plugins.vanilla.anvil;

import mezz.jei.api.gui.ingredient.IRecipeSlotDrawable;
import mezz.jei.api.recipe.IFocus;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.RecipeIngredientRole;
import mezz.jei.common.platform.IPlatformRecipeHelper;
import mezz.jei.library.util.RecipeUtil;
import net.minecraft.class_1263;
import net.minecraft.class_1277;
import net.minecraft.class_1799;
import net.minecraft.class_8062;
import java.util.List;

public class SmithingTrimCategoryExtension extends SmithingCategoryExtension<class_8062> {
	public SmithingTrimCategoryExtension(IPlatformRecipeHelper recipeHelper) {
		super(recipeHelper);
	}

	@Override
	public void onDisplayedIngredientsUpdate(
		class_8062 recipe,
		IRecipeSlotDrawable templateSlot,
		IRecipeSlotDrawable baseSlot,
		IRecipeSlotDrawable additionSlot,
		IRecipeSlotDrawable outputSlot,
		IFocusGroup focuses
	) {
		List<IFocus<?>> outputFocuses = focuses.getFocuses(RecipeIngredientRole.OUTPUT).toList();
		if (outputFocuses.isEmpty()) {
			class_1799 template = templateSlot.getDisplayedItemStack().orElse(class_1799.field_8037);
			class_1799 base = baseSlot.getDisplayedItemStack().orElse(class_1799.field_8037);
			class_1799 addition = additionSlot.getDisplayedItemStack().orElse(class_1799.field_8037);

			class_1263 recipeInput = createInput(template, base, addition);
			class_1799 output = RecipeUtil.assembleResultItem(recipeInput, recipe);
			outputSlot.createDisplayOverrides()
				.addItemStack(output);
		} else {
			class_1799 output = outputSlot.getDisplayedItemStack().orElse(class_1799.field_8037);
			class_1799 base = new class_1799(output.method_7909());
			class_1799 template = templateSlot.getDisplayedItemStack().orElse(class_1799.field_8037);
			class_1799 addition = additionSlot.getDisplayedItemStack().orElse(class_1799.field_8037);

			baseSlot.createDisplayOverrides()
				.addItemStack(base);

			class_1263 recipeInput = createInput(template, base, addition);
			output = RecipeUtil.assembleResultItem(recipeInput, recipe);
			outputSlot.createDisplayOverrides()
				.addItemStack(output);
		}
	}


	private static class_1263 createInput(class_1799 template, class_1799 base, class_1799 addition) {
		class_1263 container = new class_1277(3);
		container.method_5447(0, template);
		container.method_5447(1, base);
		container.method_5447(2, addition);
		return container;
	}
}
