package mezz.jei.fabric.mixin;

import mezz.jei.fabric.events.JeiCharTypedEvents;
import net.minecraft.class_309;
import net.minecraft.class_364;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(class_309.class)
public class KeyboardHandlerMixin {
	@Inject(
		method = "method_1458(Lnet/minecraft/client/gui/components/events/GuiEventListener;II)V",
		at = @At(
			value = "INVOKE",
			target = "Lnet/minecraft/client/gui/components/events/GuiEventListener;charTyped(CI)Z",
			ordinal = 0
		),
		cancellable = true
	)
	private static void beforeCharTypedEvent(class_364 guiEventListener, int i, int modifiers, CallbackInfo ci) {
		beforeCharTypedEventInternal(guiEventListener, (char) i, modifiers, ci);
	}

	@Inject(
		method = "method_1473(Lnet/minecraft/client/gui/components/events/GuiEventListener;CI)V",
		at = @At(
			value = "INVOKE",
			target = "Lnet/minecraft/client/gui/components/events/GuiEventListener;charTyped(CI)Z",
			ordinal = 0
		),
		cancellable = true
	)
	private static void beforeCharTypedEvent2(class_364 guiEventListener, char codepoint, int modifiers, CallbackInfo ci) {
		beforeCharTypedEventInternal(guiEventListener, codepoint, modifiers, ci);
	}

	@Inject(
		method = "method_1458(Lnet/minecraft/client/gui/components/events/GuiEventListener;II)V",
		at = @At(
			value = "INVOKE",
			target = "Lnet/minecraft/client/gui/components/events/GuiEventListener;charTyped(CI)Z",
			ordinal = 0,
			shift = At.Shift.AFTER
		),
		cancellable = true
	)
	private static void afterCharTypedEvent(class_364 guiEventListener, int i, int modifiers, CallbackInfo ci) {
		afterCharTypedEventInternal(guiEventListener, (char) i, modifiers, ci);
	}

	@Inject(
		method = "method_1473(Lnet/minecraft/client/gui/components/events/GuiEventListener;CI)V",
		at = @At(
			value = "INVOKE",
			target = "Lnet/minecraft/client/gui/components/events/GuiEventListener;charTyped(CI)Z",
			ordinal = 0,
			shift = At.Shift.AFTER
		),
		cancellable = true
	)
	private static void afterCharTypedEvent2(class_364 guiEventListener, char codepoint, int modifiers, CallbackInfo ci) {
		afterCharTypedEventInternal(guiEventListener, codepoint, modifiers, ci);
	}

	private static void beforeCharTypedEventInternal(class_364 guiEventListener, char codepoint, int modifiers, CallbackInfo ci) {
		if (ci.isCancelled()) {
			return;
		}
		if (JeiCharTypedEvents.BEFORE_CHAR_TYPED.invoker().beforeCharTyped(guiEventListener, codepoint, modifiers)) {
			ci.cancel(); // Exit the lambda
		}
	}

	private static void afterCharTypedEventInternal(class_364 guiEventListener, char codepoint, int modifiers, CallbackInfo ci) {
		if (ci.isCancelled()) {
			return;
		}
		if (JeiCharTypedEvents.AFTER_CHAR_TYPED.invoker().afterCharTyped(guiEventListener, codepoint, modifiers)) {
			ci.cancel(); // Exit the lambda
		}
	}

}
