package mezz.jei.library.plugins.debug;

import mezz.jei.api.constants.ModIds;
import mezz.jei.api.constants.RecipeTypes;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.builder.ITooltipBuilder;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.ingredient.IRecipeSlotView;
import mezz.jei.api.gui.ingredient.IRecipeSlotsView;
import mezz.jei.api.gui.inputs.IJeiInputHandler;
import mezz.jei.api.gui.inputs.IJeiUserInput;
import mezz.jei.api.gui.widgets.IRecipeExtrasBuilder;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.helpers.IPlatformFluidHelper;
import mezz.jei.api.ingredients.IIngredientHelper;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.ingredients.ITypedIngredient;
import mezz.jei.api.ingredients.subtypes.UidContext;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.IRecipeManager;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import mezz.jei.api.runtime.IBookmarkOverlay;
import mezz.jei.api.runtime.IIngredientFilter;
import mezz.jei.api.runtime.IIngredientListOverlay;
import mezz.jei.api.runtime.IIngredientManager;
import mezz.jei.api.runtime.IJeiRuntime;
import mezz.jei.common.Internal;
import mezz.jei.common.gui.JeiTooltip;
import mezz.jei.common.gui.textures.Textures;
import mezz.jei.library.plugins.debug.ingredients.DebugIngredient;
import net.minecraft.class_124;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_3612;
import net.minecraft.class_3675;
import net.minecraft.class_4185;
import net.minecraft.class_437;
import net.minecraft.class_490;
import net.minecraft.class_5250;
import net.minecraft.class_746;
import net.minecraft.class_8030;
import org.jetbrains.annotations.Nullable;

import java.util.Arrays;
import java.util.List;
import java.util.Optional;

public class DebugRecipeCategory<F> implements IRecipeCategory<DebugRecipe> {
	public static final RecipeType<DebugRecipe> TYPE = RecipeType.create(ModIds.JEI_ID, "debug", DebugRecipe.class);
	public static final int RECIPE_WIDTH = 160;
	public static final int RECIPE_HEIGHT = 60;
	private final IPlatformFluidHelper<F> platformFluidHelper;
	private final IIngredientManager ingredientManager;
	private final class_2561 localizedName;
	private final IDrawable tankBackground;
	private final IDrawable tankOverlay;
	private final IDrawable item;
	private @Nullable IJeiRuntime runtime;
	private boolean hiddenRecipes;

	public DebugRecipeCategory(IGuiHelper guiHelper, IPlatformFluidHelper<F> platformFluidHelper, IIngredientManager ingredientManager) {
		this.platformFluidHelper = platformFluidHelper;
		this.ingredientManager = ingredientManager;
		this.localizedName = class_2561.method_43470("debug");

		class_2960 backgroundTexture = new class_2960(ModIds.JEI_ID, "textures/jei/gui/debug.png");
		this.tankBackground = guiHelper.createDrawable(backgroundTexture, 220, 196, 18, 60);
		this.tankOverlay = guiHelper.createDrawable(backgroundTexture, 238, 196, 18, 60);
		this.item = guiHelper.createDrawableItemStack(new class_1799(class_1802.field_17507));
	}

	public void setRuntime(IJeiRuntime runtime) {
		this.runtime = runtime;
	}

	@Override
	public RecipeType<DebugRecipe> getRecipeType() {
		return TYPE;
	}

	@Override
	public class_2561 getTitle() {
		return localizedName;
	}

	@Override
	public int getWidth() {
		return RECIPE_WIDTH;
	}

	@Override
	public int getHeight() {
		return RECIPE_HEIGHT;
	}

	@Override
	public IDrawable getIcon() {
		Textures textures = Internal.getTextures();
		return textures.getConfigButtonIcon();
	}

	@Override
	public void draw(DebugRecipe recipe, IRecipeSlotsView recipeSlotsView, class_332 guiGraphics, double mouseX, double mouseY) {
		if (runtime != null) {
			this.item.draw(guiGraphics, 50, 20);

			IIngredientFilter ingredientFilter = runtime.getIngredientFilter();
			class_310 minecraft = class_310.method_1551();
			guiGraphics.method_51433(minecraft.field_1772, ingredientFilter.getFilterText(), 20, 52, 0, false);

			IIngredientListOverlay ingredientListOverlay = runtime.getIngredientListOverlay();
			Optional<ITypedIngredient<?>> ingredientUnderMouse = getIngredientUnderMouse(ingredientListOverlay, runtime.getBookmarkOverlay());
			ingredientUnderMouse.ifPresent(typedIngredient -> drawIngredientName(minecraft, guiGraphics, typedIngredient));
		}

		class_4185 button = recipe.getButton();
		button.method_25394(guiGraphics, (int) mouseX, (int) mouseY, 0);
	}

	private static Optional<ITypedIngredient<?>> getIngredientUnderMouse(IIngredientListOverlay ingredientListOverlay, IBookmarkOverlay bookmarkOverlay) {
		return ingredientListOverlay.getIngredientUnderMouse()
			.or(bookmarkOverlay::getIngredientUnderMouse);
	}

	private <T> void drawIngredientName(class_310 minecraft, class_332 guiGraphics, ITypedIngredient<T> ingredient) {
		IIngredientHelper<T> ingredientHelper = ingredientManager.getIngredientHelper(ingredient.getType());
		String jeiUid = ingredientHelper.getUniqueId(ingredient.getIngredient(), UidContext.Ingredient);
		guiGraphics.method_51433(minecraft.field_1772, jeiUid, 50, 52, 0, false);
	}

	@SuppressWarnings("removal")
	@Override
	public void setRecipe(IRecipeLayoutBuilder builder, DebugRecipe recipe, IFocusGroup focuses) {
		// ITEM type
		builder.addOutputSlot(70, 0)
			.addItemStack(new class_1799(class_1802.field_8365))
			.addItemStack(new class_1799(class_1802.field_27023));

		builder.addInputSlot(110, 0)
				.addIngredientsUnsafe(Arrays.asList(new class_1799(class_1802.field_8504), null));

		// FLUID type
		long bucketVolume = platformFluidHelper.bucketVolume();
		IIngredientType<F> fluidType = platformFluidHelper.getFluidIngredientType();
		{
			long capacity = 10 * bucketVolume;
			// random amount between half capacity and full
			long amount = (capacity / 2) + (int) ((Math.random() * capacity) / 2);
			builder.addOutputSlot(90, 0)
				.setFluidRenderer(capacity, false, 16, 58)
				.setOverlay(tankOverlay, -1, -1)
				.setBackground(tankBackground, -1, -1)
				.addFluidStack(class_3612.field_15910, amount);
		}

		{
			long capacity = 2 * bucketVolume;
			// random amount between half capacity and full
			long amount = (capacity / 2) + (int) ((Math.random() * capacity) / 2);
			builder.addInputSlot(24, 0)
				.setFluidRenderer(capacity, true, 12, 47)
				.addIngredient(fluidType, platformFluidHelper.create(class_3612.field_15908, amount));
		}

		// DEBUG type
		builder.addInputSlot(40, 0)
			.addIngredients(DebugIngredient.TYPE, List.of(new DebugIngredient(0), new DebugIngredient(1)));

		builder.addOutputSlot(40, 16)
			.addIngredient(DebugIngredient.TYPE, new DebugIngredient(2));

		// mixed types
		builder.addInputSlot(40, 32)
			.addIngredient(DebugIngredient.TYPE, new DebugIngredient(3))
			.addIngredientsUnsafe(List.of(
				platformFluidHelper.create(class_3612.field_15908, (int) ((1.0 + Math.random()) * bucketVolume)),
				new class_1799(class_1802.field_17507)
			))
			.addTooltipCallback(new mezz.jei.api.gui.ingredient.IRecipeSlotTooltipCallback() {
				@SuppressWarnings("removal")
				@Override
				public void onTooltip(IRecipeSlotView recipeSlotView, List<class_2561> tooltip) {
					switch (recipeSlotView.getRole()) {
						case INPUT -> tooltip.add(class_2561.method_43470("Input DebugIngredient"));
						case OUTPUT -> tooltip.add(class_2561.method_43470( "Output DebugIngredient"));
						case CATALYST -> tooltip.add(class_2561.method_43470("Catalyst DebugIngredient"));
					}
				}

				@Override
				public void onRichTooltip(IRecipeSlotView recipeSlotView, ITooltipBuilder tooltip) {
					switch (recipeSlotView.getRole()) {
						case INPUT -> tooltip.add(class_2561.method_43470("Input DebugIngredient"));
						case OUTPUT -> tooltip.add(class_2561.method_43470( "Output DebugIngredient"));
						case CATALYST -> tooltip.add(class_2561.method_43470("Catalyst DebugIngredient"));
					}
				}
			});
	}

	@Override
	public void createRecipeExtras(IRecipeExtrasBuilder builder, DebugRecipe recipe, IFocusGroup focuses) {
		builder.addInputHandler(new JeiInputHandler(recipe, new class_8030(0, 0, RECIPE_WIDTH, RECIPE_HEIGHT)));
	}

	@SuppressWarnings({"removal"})
	@Override
	public List<class_2561> getTooltipStrings(DebugRecipe recipe, IRecipeSlotsView recipeSlotsView, double mouseX, double mouseY) {
		JeiTooltip tooltip = new JeiTooltip();
		getTooltip(tooltip, recipe, recipeSlotsView, mouseX, mouseY);
		return tooltip.toLegacyToComponents();
	}

	@Override
	public void getTooltip(ITooltipBuilder tooltip, DebugRecipe recipe, IRecipeSlotsView recipeSlotsView, double mouseX, double mouseY) {
		tooltip.add(class_2561.method_43470("Debug Recipe Category Tooltip is very long and going to wrap").method_27692(class_124.field_1065));

		if (recipe.checkHover(mouseX, mouseY)) {
			tooltip.add(class_2561.method_43470("button tooltip!"));
		} else {
			class_5250 debug = class_2561.method_43470("tooltip debug");
			tooltip.add(debug.method_27692(class_124.field_1067));
		}
		tooltip.add(class_2561.method_43470(mouseX + ", " + mouseY));
	}

	public class JeiInputHandler implements IJeiInputHandler {
		private final DebugRecipe recipe;
		private final class_8030 area;

		public JeiInputHandler(DebugRecipe recipe, class_8030 area) {
			this.recipe = recipe;
			this.area = area;
		}

		@Override
		public class_8030 getArea() {
			return area;
		}

		@Override
		public boolean handleInput(double mouseX, double mouseY, IJeiUserInput userInput) {
			if (!userInput.is(Internal.getKeyMappings().getLeftClick())) {
				return false;
			}
			class_3675.class_306 key = userInput.getKey();
			class_4185 button = recipe.getButton();
			int mouseButton = key.method_1444();
			if (mouseButton == 0 && button.method_25402(mouseX, mouseY, mouseButton)) {
				if (!userInput.isSimulate()) {
					class_310 minecraft = class_310.method_1551();
					class_746 player = minecraft.field_1724;
					if (player != null) {
						class_437 screen = new class_490(player);
						minecraft.method_1507(screen);
					}
					if (runtime != null) {
						IIngredientFilter ingredientFilter = runtime.getIngredientFilter();
						String filterText = ingredientFilter.getFilterText();
						ingredientFilter.setFilterText(filterText + " test");

						IRecipeManager recipeManager = runtime.getRecipeManager();
						if (!hiddenRecipes) {
							recipeManager.hideRecipeCategory(RecipeTypes.CRAFTING);
							hiddenRecipes = true;
						} else {
							recipeManager.unhideRecipeCategory(RecipeTypes.CRAFTING);
							hiddenRecipes = false;
						}
					}
				}
				return true;
			}
			return false;
		}
	}

	@Override
	public @Nullable class_2960 getRegistryName(DebugRecipe recipe) {
		return recipe.getRegistryName();
	}
}
