package mezz.jei.library.plugins.debug.ingredients;

import com.mojang.blaze3d.systems.RenderSystem;
import mezz.jei.api.gui.builder.ITooltipBuilder;
import mezz.jei.api.ingredients.IIngredientHelper;
import mezz.jei.api.ingredients.IIngredientRenderer;
import mezz.jei.common.gui.JeiTooltip;
import net.minecraft.class_124;
import net.minecraft.class_1836;
import net.minecraft.class_1921;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_4588;
import net.minecraft.class_4597;
import net.minecraft.class_5250;
import java.util.List;

public class ErrorIngredientRenderer implements IIngredientRenderer<ErrorIngredient> {
	private static final List<class_1921> RENDER_TYPES = List.of(
		class_1921.method_51784(),
		class_1921.method_23590(),
		class_1921.method_49047(),
		class_1921.method_51785(),
		class_1921.method_51787(),
		class_1921.method_51786()
	);

	private final IIngredientHelper<ErrorIngredient> ingredientHelper;

	public ErrorIngredientRenderer(IIngredientHelper<ErrorIngredient> ingredientHelper) {
		this.ingredientHelper = ingredientHelper;
	}

	@Override
	public void render(class_332 guiGraphics, ErrorIngredient ingredient) {
		class_310 minecraft = class_310.method_1551();
		switch (ingredient.crashType()) {
			case RenderBreakVertexBufferCrash -> {
				class_4597.class_4598 bufferSource = guiGraphics.method_51450();
				for (class_1921 renderType : RENDER_TYPES) {
					class_4588 buffer = bufferSource.getBuffer(renderType);
					buffer.method_22912(0, 0, 0);
					buffer.method_39415(100);
				}
				throw new RuntimeException("intentional render crash for testing");
			}
			case TooltipCrash -> {
				class_327 font = getFontRenderer(minecraft, ingredient);
				guiGraphics.method_51433(font, "JEI", 0, 0, 0xFFFF0000, false);
				guiGraphics.method_51433(font, "TEST", 0, 8, 0xFFFF0000, false);
				RenderSystem.setShaderColor(1, 1, 1, 1);
			}
		}
	}

	@SuppressWarnings("removal")
	@Override
	public List<class_2561> getTooltip(ErrorIngredient ingredient, class_1836 tooltipFlag) {
		JeiTooltip tooltip = new JeiTooltip();
		getTooltip(tooltip, ingredient, tooltipFlag);
		return tooltip.toLegacyToComponents();
	}

	@Override
	public void getTooltip(ITooltipBuilder tooltip, ErrorIngredient ingredient, class_1836 tooltipFlag) {
		if (ingredient.crashType() == ErrorIngredient.CrashType.TooltipCrash) {
			throw new RuntimeException("intentional tooltip crash for testing");
		}
		String displayName = ingredientHelper.getDisplayName(ingredient);
		tooltip.add(class_2561.method_43470(displayName));
		class_5250 debugIngredient = class_2561.method_43470("debug ingredient");
		tooltip.add(debugIngredient.method_27692(class_124.field_1080));
	}
}
