package mezz.jei.library.plugins.vanilla.ingredients.subtypes;

import mezz.jei.api.ingredients.subtypes.IIngredientSubtypeInterpreter;
import mezz.jei.api.ingredients.subtypes.UidContext;
import mezz.jei.common.platform.IPlatformRegistry;
import mezz.jei.common.platform.Services;
import net.minecraft.class_1772;
import net.minecraft.class_1799;
import net.minecraft.class_1887;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2960;
import net.minecraft.class_7924;
import java.util.ArrayList;
import java.util.List;
import java.util.StringJoiner;

public class EnchantedBookSubtypeInterpreter implements IIngredientSubtypeInterpreter<class_1799> {
	public static final EnchantedBookSubtypeInterpreter INSTANCE = new EnchantedBookSubtypeInterpreter();

	private EnchantedBookSubtypeInterpreter() {

	}

	@Override
	public String apply(class_1799 itemStack, UidContext context) {
		List<String> strings = new ArrayList<>();
		class_2499 enchantments = class_1772.method_7806(itemStack);
		for (int i = 0; i < enchantments.size(); ++i) {
			class_2487 compoundnbt = enchantments.method_10602(i);
			String id = compoundnbt.method_10558("id");
			IPlatformRegistry<class_1887> enchantmentRegistry = Services.PLATFORM.getRegistry(class_7924.field_41265);
			class_2960 resourceLocation = class_2960.method_12829(id);
			if (resourceLocation != null) {
				enchantmentRegistry.getValue(resourceLocation)
					.map(enchantment -> enchantment.method_8184() + ".lvl" + compoundnbt.method_10568("lvl"))
					.ifPresent(strings::add);
			}
		}

		StringJoiner joiner = new StringJoiner(",", "[", "]");
		strings.sort(null);
		for (String s : strings) {
			joiner.add(s);
		}
		return joiner.toString();
	}
}
