/*
 * Decompiled with CFR 0.152.
 */
package mezz.jei.gui.overlay;

import java.util.Optional;
import java.util.function.BooleanSupplier;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.common.Internal;
import mezz.jei.common.config.IClientToggleState;
import mezz.jei.common.gui.JeiTooltip;
import mezz.jei.common.gui.textures.Textures;
import mezz.jei.common.input.IInternalKeyMappings;
import mezz.jei.common.network.IConnectionToServer;
import mezz.jei.common.network.packets.PacketRequestCheatPermission;
import mezz.jei.common.platform.IPlatformConfigHelper;
import mezz.jei.common.platform.Services;
import mezz.jei.gui.elements.GuiIconToggleButton;
import mezz.jei.gui.input.UserInput;
import net.minecraft.class_124;
import net.minecraft.class_2558;
import net.minecraft.class_2561;
import net.minecraft.class_2583;
import net.minecraft.class_310;
import net.minecraft.class_437;
import net.minecraft.class_5348;

public class ConfigButton
extends GuiIconToggleButton {
    private final IInternalKeyMappings keyBindings;
    private final BooleanSupplier isListDisplayed;
    private final IClientToggleState toggleState;

    public static ConfigButton create(BooleanSupplier isListDisplayed, IClientToggleState toggleState, IInternalKeyMappings keyBindings) {
        Textures textures = Internal.getTextures();
        return new ConfigButton(textures.getConfigButtonIcon(), textures.getConfigButtonCheatIcon(), isListDisplayed, toggleState, keyBindings);
    }

    private ConfigButton(IDrawable disabledIcon, IDrawable enabledIcon, BooleanSupplier isListDisplayed, IClientToggleState toggleState, IInternalKeyMappings keyBindings) {
        super(disabledIcon, enabledIcon);
        this.isListDisplayed = isListDisplayed;
        this.toggleState = toggleState;
        this.keyBindings = keyBindings;
    }

    @Override
    protected void getTooltips(JeiTooltip tooltip) {
        tooltip.add((class_5348)class_2561.method_43471((String)"jei.tooltip.config"));
        if (!this.toggleState.isOverlayEnabled()) {
            tooltip.add((class_5348)class_2561.method_43471((String)"jei.tooltip.ingredient.list.disabled").method_27692(class_124.field_1065));
            tooltip.addKeyUsageComponent("jei.tooltip.ingredient.list.disabled.how.to.fix", this.keyBindings.getToggleOverlay());
        } else if (!this.isListDisplayed.getAsBoolean()) {
            tooltip.add((class_5348)class_2561.method_43471((String)"jei.tooltip.not.enough.space").method_27692(class_124.field_1065));
        }
        if (this.toggleState.isCheatItemsEnabled()) {
            tooltip.add((class_5348)class_2561.method_43471((String)"jei.tooltip.cheat.mode.button.enabled").method_27692(class_124.field_1061));
            if (!this.keyBindings.getToggleCheatMode().isUnbound()) {
                tooltip.addKeyUsageComponent("jei.tooltip.cheat.mode.how.to.disable.hotkey", this.keyBindings.getToggleCheatMode());
            } else if (!this.keyBindings.getToggleCheatModeConfigButton().isUnbound()) {
                tooltip.addKeyUsageComponent("jei.tooltip.cheat.mode.how.to.disable.hover.config.button.hotkey", this.keyBindings.getToggleCheatModeConfigButton());
            }
        }
    }

    @Override
    protected boolean isIconToggledOn() {
        return this.toggleState.isCheatItemsEnabled();
    }

    @Override
    protected boolean onMouseClicked(UserInput input) {
        if (this.toggleState.isOverlayEnabled()) {
            if (!input.isSimulate()) {
                if (input.is(this.keyBindings.getToggleCheatModeConfigButton())) {
                    this.toggleState.toggleCheatItemsEnabled();
                    if (this.toggleState.isCheatItemsEnabled()) {
                        IConnectionToServer serverConnection = Internal.getServerConnection();
                        serverConnection.sendPacketToServer(new PacketRequestCheatPermission());
                    }
                } else {
                    ConfigButton.openSettings();
                }
            }
            return true;
        }
        return false;
    }

    private static void openSettings() {
        class_310 mc = class_310.method_1551();
        if (mc.field_1724 == null) {
            return;
        }
        IPlatformConfigHelper configHelper = Services.PLATFORM.getConfigHelper();
        Optional<class_437> configScreen = configHelper.getConfigScreen();
        if (configScreen.isPresent()) {
            mc.method_1507(configScreen.get());
        } else {
            class_2561 message = ConfigButton.getMissingConfigScreenMessage(configHelper);
            mc.field_1724.method_7353(message, false);
        }
    }

    private static class_2561 getMissingConfigScreenMessage(IPlatformConfigHelper configHelper) {
        return class_2561.method_43471((String)"jei.message.configured").method_10862(class_2583.field_24360.method_10977(class_124.field_1058).method_30938(Boolean.valueOf(true)).method_10958(new class_2558(class_2558.class_2559.field_11749, "https://www.curseforge.com/minecraft/mc-mods/configured"))).method_27693("\n").method_10852((class_2561)class_2561.method_43471((String)"jei.message.config.folder").method_10862(class_2583.field_24360.method_10977(class_124.field_1068).method_30938(Boolean.valueOf(true)).method_10958(new class_2558(class_2558.class_2559.field_11746, configHelper.createJeiConfigDir().toAbsolutePath().toString()))));
    }
}

