package mezz.jei.gui.recipes;

import mezz.jei.api.gui.IRecipeLayoutDrawable;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.runtime.IIngredientManager;
import mezz.jei.common.Internal;
import mezz.jei.common.gui.JeiTooltip;
import mezz.jei.common.gui.textures.Textures;
import mezz.jei.gui.bookmarks.BookmarkList;
import mezz.jei.gui.bookmarks.RecipeBookmark;
import mezz.jei.gui.elements.GuiIconToggleButton;
import mezz.jei.gui.input.UserInput;
import net.minecraft.class_1921;
import net.minecraft.class_2561;
import net.minecraft.class_332;
import net.minecraft.class_768;
import org.jetbrains.annotations.Nullable;

public class RecipeBookmarkButton extends GuiIconToggleButton {
	private final BookmarkList bookmarks;
	private final @Nullable RecipeBookmark<?, ?> recipeBookmark;
	private boolean bookmarked;

	public static RecipeBookmarkButton create(
		IRecipeLayoutDrawable<?> recipeLayout,
		IIngredientManager ingredientManager,
		BookmarkList bookmarks
	) {
		RecipeBookmark<?, ?> recipeBookmark = RecipeBookmark.create(recipeLayout, ingredientManager)
			.orElse(null);

		Textures textures = Internal.getTextures();
		IDrawable icon = textures.getRecipeBookmark();
		class_768 area = recipeLayout.getRecipeBookmarkButtonArea();
		class_768 layoutArea = recipeLayout.getRect();
		area.method_35778(area.method_3321() + layoutArea.method_3321());
		area.method_35781(area.method_3322() + layoutArea.method_3322());

		RecipeBookmarkButton recipeBookmarkButton = new RecipeBookmarkButton(icon, bookmarks, recipeBookmark);
		recipeBookmarkButton.updateBounds(area);
		return recipeBookmarkButton;
	}

	private RecipeBookmarkButton(IDrawable icon, BookmarkList bookmarks, @Nullable RecipeBookmark<?, ?> recipeBookmark) {
		super(icon, icon);

		this.bookmarks = bookmarks;
		this.recipeBookmark = recipeBookmark;

		if (recipeBookmark == null) {
			button.field_22763 = false;
			button.field_22764 = false;
		}

		tick();
	}

	@Override
	protected void getTooltips(JeiTooltip tooltip) {
		if (recipeBookmark != null) {
			if (bookmarks.contains(recipeBookmark)) {
				tooltip.add(class_2561.method_43471("jei.tooltip.bookmarks.recipe.remove"));
			} else {
				tooltip.add(class_2561.method_43471("jei.tooltip.bookmarks.recipe.add"));
			}
		}
	}

	@Override
	public void tick() {
		bookmarked = recipeBookmark != null && bookmarks.contains(recipeBookmark);
	}

	@Override
	protected boolean isIconToggledOn() {
		return bookmarked;
	}

	@Override
	protected boolean onMouseClicked(UserInput input) {
		if (recipeBookmark != null) {
			if (!input.isSimulate()) {
				bookmarks.toggleBookmark(recipeBookmark);
			}
			return true;
		}
		return false;
	}

	@Override
	public void draw(class_332 guiGraphics, int mouseX, int mouseY, float partialTicks) {
		super.draw(guiGraphics, mouseX, mouseY, partialTicks);
		if (bookmarked) {
			guiGraphics.method_51739(
				class_1921.method_51784(),
				button.method_46426(),
				button.method_46427(),
				button.method_46426() + button.method_25368(),
				button.method_46427() + button.method_25364(),
				0x1100FF00
			);
		}
	}

	public boolean isBookmarked() {
		return bookmarked;
	}
}
