package mezz.jei.common.util;

import org.jetbrains.annotations.Nullable;
import java.util.Locale;
import java.util.function.Supplier;
import net.minecraft.class_1076;
import net.minecraft.class_310;

public class MinecraftLocaleSupplier implements Supplier<Locale> {
	@Nullable
	private String cachedLocaleCode;
	@Nullable
	private Locale cachedLocale;

	@Override
	public Locale get() {
		class_310 minecraft = class_310.method_1551();
		//noinspection ConstantValue
		if (minecraft == null) {
			return Locale.getDefault();
		}
		class_1076 languageManager = minecraft.method_1526();
		String code = languageManager.method_4669();
		if (cachedLocale == null || !code.equals(cachedLocaleCode)) {
			cachedLocaleCode = code;
			String[] splitLangCode = code.split("_", 2);
			if (splitLangCode.length == 1) { // Vanilla has some languages without underscores
				cachedLocale = new Locale(code);
			} else {
				cachedLocale = new Locale(splitLangCode[0], splitLangCode[1]);
			}
		}
		return cachedLocale;
	}
}
