package mezz.jei.common.transfer;

import net.minecraft.class_1703;
import net.minecraft.class_1735;
import net.minecraft.class_2540;

/**
 * Represents transferring an ItemStack from inventorySlot to craftingSlot.
 */
public record TransferOperation(int inventorySlotId, int craftingSlotId) {
	public static TransferOperation readPacketData(class_2540 buf, class_1703 container) {
		int inventorySlotId = buf.method_10816();
		int craftingSlotId = buf.method_10816();
		return new TransferOperation(inventorySlotId, craftingSlotId);
	}

	public void writePacketData(class_2540 buf) {
		buf.method_10804(inventorySlotId);
		buf.method_10804(craftingSlotId);
	}

	public class_1735 inventorySlot(class_1703 container) {
		return container.method_7611(inventorySlotId);
	}

	public class_1735 craftingSlot(class_1703 container) {
		return container.method_7611(craftingSlotId);
	}
}
