package mezz.jei.gui.ingredients;

import mezz.jei.api.gui.builder.ITooltipBuilder;
import mezz.jei.api.ingredients.ITypedIngredient;
import mezz.jei.common.util.StringUtil;
import mezz.jei.common.util.Translator;
import net.minecraft.class_2561;
import net.minecraft.class_5348;
import net.minecraft.class_5632;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;

public class ListElementInfoTooltip implements ITooltipBuilder {
	private final List<class_5348> tooltip = new ArrayList<>();

	@Override
	public void add(class_5348 component) {
		tooltip.add(component);
	}

	@Override
	public void addAll(Collection<? extends class_5348> components) {
		tooltip.addAll(components);
	}

	@Override
	public void add(class_5632 component) {
		// ignored for the purposes of searching tooltips
	}

	@Override
	public void setIngredient(ITypedIngredient<?> typedIngredient) {
		// ignored for the purposes of searching tooltips
	}

	@SuppressWarnings("removal")
	@Override
	public List<class_2561> toLegacyToComponents() {
		return tooltip.stream()
			.<class_2561>mapMulti((f, consumer) -> {
				if (f instanceof class_2561 c) {
					consumer.accept(c);
				}
			})
			.collect(Collectors.toCollection(ArrayList::new));
	}

	@SuppressWarnings("removal")
	@Override
	public void removeAll(List<class_2561> components) {
		for (class_2561 component : components) {
			tooltip.remove(component);
		}
	}

	public Set<String> getStrings() {
		Set<String> result = new HashSet<>();
		for (class_5348 component : tooltip) {
			String string = component.getString();
			string = StringUtil.removeChatFormatting(string);
			string = Translator.toLowercaseWithLocale(string);
			// Split tooltip strings into words to keep them from being too long.
			// Longer strings are more expensive for the suffix tree to handle.
			String[] strings = string.split(" ");
			Collections.addAll(result, strings);
		}
		return result;
	}
}
