package mezz.jei.api.recipe.vanilla;

import org.jetbrains.annotations.Unmodifiable;

import javax.annotation.Nonnegative;
import net.minecraft.class_1799;
import net.minecraft.class_2960;
import net.minecraft.class_3962;
import java.util.List;

/**
 * Recipes representing ingredients that can be composted in the composter.
 *
 * JEI automatically creates these recipes from {@link class_3962#field_17566}.
 *
 * @since 9.5.0
 */
public interface IJeiCompostingRecipe {
	/**
	 * Get the inputs to this recipe.
	 * @since 9.5.0
	 */
	@Unmodifiable
	List<class_1799> getInputs();

	/**
	 * Get the chance of this input adding a level of compost to the composter.
	 *
	 * @since 9.5.0
	 */
	@Nonnegative
	float getChance();

	/**
	 * Unique ID for this recipe.
	 * @since 15.5.0
	 */
	class_2960 getUid();
}
