package mezz.jei.library.ingredients.itemStacks;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.ingredients.ITypedIngredient;
import net.minecraft.class_1799;
import java.time.Duration;
import java.util.Optional;

public abstract class TypedItemStack implements ITypedIngredient<class_1799> {
	private static final LoadingCache<TypedItemStack, class_1799> CACHE = CacheBuilder.newBuilder()
		.expireAfterAccess(Duration.ofSeconds(1))
		.build(new CacheLoader<>() {
			@Override
			public class_1799 load(TypedItemStack key) {
				return key.createItemStackUncached();
			}
		});

	public static ITypedIngredient<class_1799> create(class_1799 ingredient) {
		if (ingredient.method_7947() == 1) {
			return NormalizedTypedItemStack.create(
				ingredient.method_41409(),
				ingredient.method_7969()
			);
		}
		return new FullTypedItemStack(
			ingredient.method_41409(),
			ingredient.method_7969(),
			ingredient.method_7947()
		);
	}

	public static ITypedIngredient<class_1799> normalize(ITypedIngredient<class_1799> typedIngredient) {
		if (typedIngredient instanceof TypedItemStack typedItemStack) {
			return typedItemStack.getNormalized();
		}
		class_1799 itemStack = typedIngredient.getIngredient();
		return NormalizedTypedItemStack.create(itemStack.method_41409(), itemStack.method_7969());
	}

	@Override
	public final class_1799 getIngredient() {
		return CACHE.getUnchecked(this);
	}

	@Override
	public final Optional<class_1799> getItemStack() {
		return Optional.of(getIngredient());
	}

	@Override
	public final IIngredientType<class_1799> getType() {
		return VanillaTypes.ITEM_STACK;
	}

	protected abstract TypedItemStack getNormalized();

	protected abstract class_1799 createItemStackUncached();
}
