package mezz.jei.api.fabric.constants;

import mezz.jei.api.fabric.ingredients.fluids.IJeiFluidIngredient;
import mezz.jei.api.fabric.ingredients.fluids.JeiFluidIngredient;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.ingredients.IIngredientTypeWithSubtypes;
import net.fabricmc.fabric.api.transfer.v1.fluid.FluidConstants;
import net.minecraft.class_3611;

/**
 * Built-in {@link IIngredientType} for Fabric Minecraft.
 *
 * @since 10.1.0
 */
public final class FabricTypes {
	/**
	 * @since 10.1.0
	 */
	public static final IIngredientTypeWithSubtypes<class_3611, IJeiFluidIngredient> FLUID_STACK = new IIngredientTypeWithSubtypes<>() {
		@Override
		public String getUid() {
			return "fluid_stack";
		}

		@Override
		public Class<? extends IJeiFluidIngredient> getIngredientClass() {
			return IJeiFluidIngredient.class;
		}

		@Override
		public Class<? extends class_3611> getIngredientBaseClass() {
			return class_3611.class;
		}

		@Override
		public class_3611 getBase(IJeiFluidIngredient ingredient) {
			return ingredient.getFluid();
		}

		@SuppressWarnings("UnstableApiUsage")
		@Override
		public IJeiFluidIngredient getDefaultIngredient(class_3611 base) {
			return new JeiFluidIngredient(base, FluidConstants.BUCKET, null);
		}
	};

	private FabricTypes() {}
}
