/*
 * Decompiled with CFR 0.152.
 */
package mezz.jei.common.transfer;

import it.unimi.dsi.fastutil.Hash;
import it.unimi.dsi.fastutil.objects.Object2ObjectArrayMap;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenCustomHashMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import mezz.jei.api.gui.IRecipeLayoutDrawable;
import mezz.jei.api.gui.ingredient.IRecipeSlotView;
import mezz.jei.api.gui.ingredient.IRecipeSlotsView;
import mezz.jei.api.helpers.IStackHelper;
import mezz.jei.api.ingredients.subtypes.UidContext;
import mezz.jei.api.recipe.category.IRecipeCategory;
import mezz.jei.api.recipe.transfer.IRecipeTransferError;
import mezz.jei.api.recipe.transfer.IRecipeTransferHandler;
import mezz.jei.api.recipe.transfer.IRecipeTransferManager;
import mezz.jei.common.transfer.RecipeTransferErrorInternal;
import mezz.jei.common.transfer.RecipeTransferOperationsResult;
import mezz.jei.common.transfer.TransferOperation;
import mezz.jei.common.util.StringUtil;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public final class RecipeTransferUtil {
    private static final Logger LOGGER = LogManager.getLogger();

    private RecipeTransferUtil() {
    }

    public static Optional<IRecipeTransferError> getTransferRecipeError(IRecipeTransferManager recipeTransferManager, AbstractContainerMenu container, IRecipeLayoutDrawable<?> recipeLayout, Player player) {
        return RecipeTransferUtil.transferRecipe(recipeTransferManager, container, recipeLayout, player, false, false);
    }

    public static boolean transferRecipe(IRecipeTransferManager recipeTransferManager, AbstractContainerMenu container, IRecipeLayoutDrawable<?> recipeLayout, Player player, boolean maxTransfer) {
        return RecipeTransferUtil.transferRecipe(recipeTransferManager, container, recipeLayout, player, maxTransfer, true).map(error -> error.getType().allowsTransfer).orElse(true);
    }

    private static <C extends AbstractContainerMenu, R> Optional<IRecipeTransferError> transferRecipe(IRecipeTransferManager recipeTransferManager, C container, IRecipeLayoutDrawable<R> recipeLayout, Player player, boolean maxTransfer, boolean doTransfer) {
        IRecipeCategory recipeCategory = recipeLayout.getRecipeCategory();
        Optional recipeTransferHandler = recipeTransferManager.getRecipeTransferHandler(container, recipeCategory);
        if (recipeTransferHandler.isEmpty()) {
            if (doTransfer) {
                LOGGER.error("No Recipe Transfer handler for container {}", container.getClass());
            }
            return Optional.of(RecipeTransferErrorInternal.INSTANCE);
        }
        IRecipeTransferHandler transferHandler = (IRecipeTransferHandler)recipeTransferHandler.get();
        IRecipeSlotsView recipeSlotsView = recipeLayout.getRecipeSlotsView();
        try {
            IRecipeTransferError transferError = transferHandler.transferRecipe(container, recipeLayout.getRecipe(), recipeSlotsView, player, maxTransfer, doTransfer);
            return Optional.ofNullable(transferError);
        }
        catch (RuntimeException e) {
            LOGGER.error("Recipe transfer handler '{}' for container '{}' and recipe type '{}' threw an error: ", transferHandler.getClass(), (Object)transferHandler.getContainerClass(), (Object)recipeCategory.getRecipeType(), (Object)e);
            return Optional.of(RecipeTransferErrorInternal.INSTANCE);
        }
    }

    public static boolean validateSlots(Player player, Collection<TransferOperation> transferOperations, Collection<Slot> craftingSlots, Collection<Slot> inventorySlots) {
        Set<Integer> inventorySlotIndexes = inventorySlots.stream().map(s -> s.index).collect(Collectors.toSet());
        Set<Integer> craftingSlotIndexes = craftingSlots.stream().map(s -> s.index).collect(Collectors.toSet());
        List<Integer> invalidRecipeIndexes = transferOperations.stream().map(op -> op.craftingSlot(player.containerMenu)).map(s -> s.index).filter(s -> !craftingSlotIndexes.contains(s)).toList();
        if (!invalidRecipeIndexes.isEmpty()) {
            LOGGER.error("Transfer request has invalid slots for the destination of the recipe, the slots are not included in the list of crafting slots. {}", (Object)StringUtil.intsToString(invalidRecipeIndexes));
            return false;
        }
        List<Integer> invalidInventorySlotIndexes = transferOperations.stream().map(op -> op.inventorySlot(player.containerMenu)).map(s -> s.index).filter(s -> !inventorySlotIndexes.contains(s) && !craftingSlotIndexes.contains(s)).toList();
        if (!invalidInventorySlotIndexes.isEmpty()) {
            LOGGER.error("Transfer request has invalid source slots for the inventory stacks for the recipe, the slots are not included in the list of inventory slots or recipe slots. {}\n inventory slots: {}\n crafting slots: {}", (Object)StringUtil.intsToString(invalidInventorySlotIndexes), (Object)StringUtil.intsToString(inventorySlotIndexes), (Object)StringUtil.intsToString(craftingSlotIndexes));
            return false;
        }
        Set<Integer> overlappingSlots = inventorySlotIndexes.stream().filter(craftingSlotIndexes::contains).collect(Collectors.toSet());
        if (!overlappingSlots.isEmpty()) {
            LOGGER.error("Transfer request has invalid slots, inventorySlots and craftingSlots should not share any slot, but both have: {}", (Object)StringUtil.intsToString(overlappingSlots));
            return false;
        }
        List<Integer> invalidPickupSlots = Stream.concat(craftingSlots.stream(), inventorySlots.stream()).filter(Slot::hasItem).filter(slot -> !slot.mayPickup(player)).map(slot -> slot.index).toList();
        if (!invalidPickupSlots.isEmpty()) {
            LOGGER.error("Transfer request has invalid slots, the player is unable to pickup from them: {}", (Object)StringUtil.intsToString(invalidPickupSlots));
            return false;
        }
        return true;
    }

    /*
     * WARNING - void declaration
     */
    public static RecipeTransferOperationsResult getRecipeTransferOperations(final IStackHelper stackhelper, Map<Slot, ItemStack> availableItemStacks, List<IRecipeSlotView> requiredItemStacks, List<Slot> craftingSlots) {
        void var9_12;
        RecipeTransferOperationsResult transferOperations = new RecipeTransferOperationsResult();
        IdentityHashMap<IRecipeSlotView, Map> relevantSlots = new IdentityHashMap<IRecipeSlotView, Map>();
        IdentityHashMap<IRecipeSlotView, Set> slotUidCache = new IdentityHashMap<IRecipeSlotView, Set>();
        List<IRecipeSlotView> nonEmptyRequiredStacks = requiredItemStacks.stream().filter(r -> !r.isEmpty()).toList();
        for (Map.Entry<Slot, ItemStack> entry : availableItemStacks.entrySet()) {
            ItemStack itemStack = entry.getValue();
            String slotItemStackUid = stackhelper.getUniqueIdentifierForStack(itemStack, UidContext.Ingredient);
            for (IRecipeSlotView iRecipeSlotView : nonEmptyRequiredStacks) {
                Set ingredientUids = slotUidCache.computeIfAbsent(iRecipeSlotView, s -> s.getItemStacks().map(i -> stackhelper.getUniqueIdentifierForStack(i, UidContext.Ingredient)).collect(Collectors.toSet()));
                if (!ingredientUids.contains(slotItemStackUid)) continue;
                relevantSlots.computeIfAbsent(iRecipeSlotView, it -> new Object2ObjectOpenCustomHashMap((Hash.Strategy)new Hash.Strategy<ItemStack>(){

                    public int hashCode(ItemStack o) {
                        return o.getItem().hashCode();
                    }

                    public boolean equals(ItemStack a, ItemStack b) {
                        return stackhelper.isEquivalent(a, b, UidContext.Ingredient);
                    }
                })).computeIfAbsent(itemStack, it -> new ArrayList()).add(new PhantomSlotState(entry.getKey(), itemStack));
            }
        }
        Object2ObjectArrayMap bestMatches = new Object2ObjectArrayMap();
        for (Map.Entry entry : relevantSlots.entrySet()) {
            ArrayList<PhantomSlotStateList> countedAndSorted = new ArrayList<PhantomSlotStateList>();
            for (Map.Entry entry2 : ((Map)entry.getValue()).entrySet()) {
                ((ArrayList)entry2.getValue()).sort((o1, o2) -> {
                    int compare = Integer.compare(o1.itemStack.getCount(), o2.itemStack.getCount());
                    if (compare == 0) {
                        return Integer.compare(o1.slot.index, o2.slot.index);
                    }
                    return compare;
                });
                countedAndSorted.add(new PhantomSlotStateList((List)entry2.getValue()));
            }
            countedAndSorted.sort((o1, o2) -> {
                int compare = Long.compare(o2.totalItemCount, o1.totalItemCount);
                if (compare == 0) {
                    return Integer.compare(o1.stateList.stream().mapToInt(it -> it.slot.index).min().orElse(0), o2.stateList.stream().mapToInt(it -> it.slot.index).min().orElse(0));
                }
                return compare;
            });
            bestMatches.put((IRecipeSlotView)entry.getKey(), countedAndSorted);
        }
        boolean bl = false;
        while (var9_12 < requiredItemStacks.size()) {
            IRecipeSlotView iRecipeSlotView = requiredItemStacks.get((int)var9_12);
            if (!iRecipeSlotView.isEmpty()) {
                Slot craftingSlot = craftingSlots.get((int)var9_12);
                PhantomSlotState matching = null;
                List list = (List)bestMatches.get(iRecipeSlotView);
                if (list != null) {
                    for (PhantomSlotStateList phantomSlotStateList : list) {
                        PhantomSlotState first = phantomSlotStateList.getFirstNonEmpty();
                        if (first == null) continue;
                        matching = first;
                        break;
                    }
                }
                if (matching == null) {
                    transferOperations.missingItems.add(iRecipeSlotView);
                } else {
                    Slot matchingSlot = matching.slot;
                    ItemStack matchingStack = matching.itemStack;
                    matchingStack.shrink(1);
                    transferOperations.results.add(new TransferOperation(matchingSlot.index, craftingSlot.index));
                }
            }
            ++var9_12;
        }
        return transferOperations;
    }

    private record PhantomSlotState(Slot slot, ItemStack itemStack) {
    }

    private record PhantomSlotStateList(List<PhantomSlotState> stateList, long totalItemCount) {
        public PhantomSlotStateList(List<PhantomSlotState> states) {
            this(states, states.stream().mapToLong(it -> it.itemStack.getCount()).sum());
        }

        @Nullable
        public PhantomSlotState getFirstNonEmpty() {
            for (PhantomSlotState state : this.stateList) {
                if (state.itemStack.isEmpty()) continue;
                return state;
            }
            return null;
        }
    }
}

