/*
 * Decompiled with CFR 0.152.
 */
package mezz.jei.api.gui.handlers;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import mezz.jei.api.gui.builder.ITooltipBuilder;
import mezz.jei.api.recipe.IFocusFactory;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.runtime.IRecipesGui;
import net.minecraft.client.renderer.Rect2i;
import net.minecraft.network.chat.Component;

public interface IGuiClickableArea {
    public Rect2i getArea();

    default public boolean isTooltipEnabled() {
        return true;
    }

    @Deprecated(since="15.8.4", forRemoval=true)
    default public List<Component> getTooltipStrings() {
        return Collections.emptyList();
    }

    default public void getTooltip(ITooltipBuilder tooltip) {
        tooltip.addAll(this.getTooltipStrings());
    }

    public void onClick(IFocusFactory var1, IRecipesGui var2);

    public static IGuiClickableArea createBasic(int xPos, int yPos, int width, int height, RecipeType<?> ... recipeTypes) {
        final Rect2i area = new Rect2i(xPos, yPos, width, height);
        final List<RecipeType<?>> recipeTypesList = Arrays.asList(recipeTypes);
        return new IGuiClickableArea(){

            @Override
            public Rect2i getArea() {
                return area;
            }

            @Override
            public void onClick(IFocusFactory focusFactory, IRecipesGui recipesGui) {
                recipesGui.showTypes(recipeTypesList);
            }
        };
    }
}

