package mezz.jei.gui;

import mezz.jei.gui.elements.GuiIconButton;
import mezz.jei.common.gui.textures.Textures;
import mezz.jei.gui.input.IPaged;
import mezz.jei.gui.input.IUserInputHandler;
import mezz.jei.gui.input.handlers.CombinedInputHandler;
import net.minecraft.class_1921;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_332;
import mezz.jei.common.util.ImmutableRect2i;
import mezz.jei.common.util.MathUtil;

public class PageNavigation {
	private final IPaged paged;
	private final GuiIconButton nextButton;
	private final GuiIconButton backButton;
	private final boolean hideOnSinglePage;
	private String pageNumDisplayString = "1/1";
	private ImmutableRect2i area = ImmutableRect2i.EMPTY;

	public PageNavigation(IPaged paged, boolean hideOnSinglePage, Textures textures) {
		this.paged = paged;
		this.nextButton = new GuiIconButton(textures.getArrowNext(), b -> paged.nextPage(), textures);
		this.backButton = new GuiIconButton(textures.getArrowPrevious(), b -> paged.previousPage(), textures);
		this.hideOnSinglePage = hideOnSinglePage;
	}

	private boolean isVisible() {
		if (area.isEmpty()) {
			return false;
		}
		return !hideOnSinglePage || this.paged.hasNext() || this.paged.hasPrevious();
	}

	public void updateBounds(ImmutableRect2i area) {
		this.area = area;
		int buttonSize = area.getHeight();

		ImmutableRect2i backArea = area.keepLeft(buttonSize);
		this.backButton.updateBounds(backArea);

		ImmutableRect2i nextArea = area.keepRight(buttonSize);
		this.nextButton.updateBounds(nextArea);
	}

	public void updatePageNumber() {
		int pageNum = this.paged.getPageNumber();
		int pageCount = this.paged.getPageCount();
		this.pageNumDisplayString = String.format("%d/%d", pageNum + 1, pageCount);
	}

	public void draw(class_310 minecraft, class_332 guiGraphics, int mouseX, int mouseY, float partialTicks) {
		if (isVisible()) {
			guiGraphics.method_51739(
				class_1921.method_51784(),
				backButton.method_46426() + backButton.method_25368(),
				backButton.method_46427(),
				nextButton.method_46426(),
				nextButton.method_46427() + nextButton.method_25364(),
				0x30000000
			);

			class_327 font = minecraft.field_1772;
			ImmutableRect2i centerArea = MathUtil.centerTextArea(this.area, font, this.pageNumDisplayString);
			guiGraphics.method_25303(font, pageNumDisplayString, centerArea.getX(), centerArea.getY(), 0xFFFFFFFF);
			nextButton.method_25394(guiGraphics, mouseX, mouseY, partialTicks);
			backButton.method_25394(guiGraphics, mouseX, mouseY, partialTicks);
		}
	}

	public IUserInputHandler createInputHandler() {
		return new CombinedInputHandler(
			this.nextButton.createInputHandler(),
			this.backButton.createInputHandler()
		);
	}
}
