package mezz.jei.gui.ingredients;

import mezz.jei.api.ingredients.IIngredientHelper;
import mezz.jei.api.ingredients.IIngredientRenderer;
import mezz.jei.common.config.IIngredientFilterConfig;
import mezz.jei.common.util.Translator;
import net.minecraft.class_124;
import net.minecraft.class_1836;
import net.minecraft.class_2561;
import net.minecraft.class_3544;
import org.jetbrains.annotations.Unmodifiable;

import java.util.List;
import java.util.Set;

public final class IngredientInformationUtil {
	private IngredientInformationUtil() {
	}

	public static <T> String getDisplayName(T ingredient, IIngredientHelper<T> ingredientHelper) {
		String displayName = ingredientHelper.getDisplayName(ingredient);
		return removeChatFormatting(displayName);
	}

	@Unmodifiable
	public static <T> List<String> getTooltipStrings(T ingredient, IIngredientRenderer<T> ingredientRenderer, Set<String> toRemove, IIngredientFilterConfig config) {
		class_1836.class_1837 tooltipFlag = config.getSearchAdvancedTooltips() ? class_1836.class_1837.field_41071 : class_1836.class_1837.field_41070;
		List<class_2561> tooltip = ingredientRenderer.getTooltip(ingredient, tooltipFlag);
		return tooltip.stream()
			.map(class_2561::getString)
			.map(IngredientInformationUtil::removeChatFormatting)
			.map(Translator::toLowercaseWithLocale)
			.map(line -> {
				for (String excludeWord : toRemove) {
					line = line.replace(excludeWord, "");
				}
				return line;
			})
			.filter(line -> !class_3544.method_15438(line))
			.toList();
	}

	private static String removeChatFormatting(String string) {
		String withoutFormattingCodes = class_124.method_539(string);
		return (withoutFormattingCodes == null) ? "" : withoutFormattingCodes;
	}

}
