/*
 * Decompiled with CFR 0.152.
 */
package mezz.jei.common.util;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.tree.CommandNode;
import com.mojang.brigadier.tree.RootCommandNode;
import java.util.Optional;
import mezz.jei.common.config.GiveMode;
import mezz.jei.common.config.IServerConfig;
import mezz.jei.common.network.IConnectionToClient;
import mezz.jei.common.network.ServerPacketContext;
import mezz.jei.common.network.packets.PacketCheatPermission;
import net.minecraft.class_1542;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1703;
import net.minecraft.class_1799;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2561;
import net.minecraft.class_3222;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_5250;
import net.minecraft.server.MinecraftServer;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public final class ServerCommandUtil {
    private static final Logger LOGGER = LogManager.getLogger();

    private ServerCommandUtil() {
    }

    public static boolean hasPermissionForCheatMode(class_3222 sender, IServerConfig serverConfig) {
        MinecraftServer minecraftServer;
        if (serverConfig.isCheatModeEnabledForCreative() && sender.method_7337()) {
            return true;
        }
        class_2168 commandSource = sender.method_5671();
        if (serverConfig.isCheatModeEnabledForOp() && (minecraftServer = sender.method_5682()) != null) {
            int opPermissionLevel = minecraftServer.method_3798();
            return commandSource.method_9259(opPermissionLevel);
        }
        if (serverConfig.isCheatModeEnabledForGive()) {
            return ServerCommandUtil.getGiveCommand((class_1657)sender).map(giveCommand -> giveCommand.canUse((Object)commandSource)).orElse(false);
        }
        return false;
    }

    public static void executeGive(ServerPacketContext context, class_1799 itemStack, GiveMode giveMode) {
        IServerConfig serverConfig;
        class_3222 sender = context.player();
        if (ServerCommandUtil.hasPermissionForCheatMode(sender, serverConfig = context.serverConfig())) {
            if (itemStack.method_7960()) {
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug("Player '{} ({})' tried to give an empty ItemStack.", (Object)sender.method_5477(), (Object)sender.method_5667());
                }
                return;
            }
            if (giveMode == GiveMode.INVENTORY) {
                ServerCommandUtil.giveToInventory((class_1657)sender, itemStack);
            } else if (giveMode == GiveMode.MOUSE_PICKUP) {
                ServerCommandUtil.mousePickupItemStack((class_1657)sender, itemStack);
            }
        } else {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("Player '{} ({})' tried to cheat an ItemStack '{}' but does not have permission.", (Object)sender.method_5477(), (Object)sender.method_5667(), (Object)itemStack.method_7954());
            }
            IConnectionToClient connection = context.connection();
            connection.sendPacketToClient(new PacketCheatPermission(false), sender);
        }
    }

    public static void setHotbarSlot(ServerPacketContext context, class_1799 itemStack, int hotbarSlot) {
        IServerConfig serverConfig;
        class_3222 sender = context.player();
        if (ServerCommandUtil.hasPermissionForCheatMode(sender, serverConfig = context.serverConfig())) {
            if (itemStack.method_7960()) {
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug("Player '{} ({})' tried to set an empty ItemStack to the hotbar slot: {}", (Object)sender.method_5477(), (Object)sender.method_5667(), (Object)hotbarSlot);
                }
                return;
            }
            if (!class_1661.method_7380((int)hotbarSlot)) {
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug("Player '{} ({})' tried to set slot that is not in the hotbar: {}", (Object)sender.method_5477(), (Object)sender.method_5667(), (Object)hotbarSlot);
                }
                return;
            }
            class_1799 stackInSlot = sender.method_31548().method_5438(hotbarSlot);
            if (class_1799.method_7973((class_1799)stackInSlot, (class_1799)itemStack)) {
                return;
            }
            class_1799 itemStackCopy = itemStack.method_7972();
            sender.method_31548().method_5447(hotbarSlot, itemStack);
            sender.method_37908().method_43128(null, sender.method_23317(), sender.method_23318(), sender.method_23321(), class_3417.field_15197, class_3419.field_15248, 0.2f, ((sender.method_6051().method_43057() - sender.method_6051().method_43057()) * 0.7f + 1.0f) * 2.0f);
            sender.field_7498.method_7623();
            ServerCommandUtil.notifyGive((class_1657)sender, itemStackCopy);
        } else {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("Player '{} ({})' tried to cheat an item '{}' to their hotbar but does not have permission.", (Object)sender.method_5477(), (Object)sender.method_5667(), (Object)itemStack.method_7954());
            }
            IConnectionToClient connection = context.connection();
            connection.sendPacketToClient(new PacketCheatPermission(false), sender);
        }
    }

    public static void mousePickupItemStack(class_1657 sender, class_1799 itemStack) {
        int giveCount;
        class_1703 containerMenu = sender.field_7512;
        class_1799 itemStackCopy = itemStack.method_7972();
        class_1799 existingStack = containerMenu.method_34255();
        if (ServerCommandUtil.canStack(existingStack, itemStack)) {
            int newCount = Math.min(existingStack.method_7914(), existingStack.method_7947() + itemStack.method_7947());
            giveCount = newCount - existingStack.method_7947();
            existingStack.method_7939(newCount);
        } else {
            containerMenu.method_34254(itemStack);
            giveCount = itemStack.method_7947();
        }
        if (giveCount > 0) {
            itemStackCopy.method_7939(giveCount);
            ServerCommandUtil.notifyGive(sender, itemStackCopy);
            containerMenu.method_7623();
        }
    }

    public static boolean canStack(class_1799 a, class_1799 b) {
        class_1799 singleStack = a.method_7972();
        singleStack.method_7939(1);
        return class_1542.method_24017((class_1799)singleStack, (class_1799)b);
    }

    private static void giveToInventory(class_1657 entityplayermp, class_1799 itemStack) {
        class_1799 itemStackCopy = itemStack.method_7972();
        boolean flag = entityplayermp.method_31548().method_7394(itemStack);
        if (flag && itemStack.method_7960()) {
            itemStack.method_7939(1);
            class_1542 entityitem = entityplayermp.method_7328(itemStack, false);
            if (entityitem != null) {
                entityitem.method_6987();
            }
            entityplayermp.method_37908().method_43128(null, entityplayermp.method_23317(), entityplayermp.method_23318(), entityplayermp.method_23321(), class_3417.field_15197, class_3419.field_15248, 0.2f, ((entityplayermp.method_6051().method_43057() - entityplayermp.method_6051().method_43057()) * 0.7f + 1.0f) * 2.0f);
            entityplayermp.field_7498.method_7623();
        } else {
            class_1542 entityitem = entityplayermp.method_7328(itemStack, false);
            if (entityitem != null) {
                entityitem.method_6975();
                entityitem.method_48349(entityplayermp.method_5667());
            }
        }
        ServerCommandUtil.notifyGive(entityplayermp, itemStackCopy);
    }

    private static void notifyGive(class_1657 player, class_1799 stack) {
        if (player.method_5682() == null) {
            return;
        }
        class_2168 commandSource = player.method_5671();
        int count = stack.method_7947();
        class_2561 stackTextComponent = stack.method_7954();
        class_2561 displayName = player.method_5476();
        class_5250 message = class_2561.method_43469((String)"commands.give.success.single", (Object[])new Object[]{count, stackTextComponent, displayName});
        commandSource.method_9226(() -> ServerCommandUtil.lambda$notifyGive$1((class_2561)message), true);
    }

    private static Optional<CommandNode<class_2168>> getGiveCommand(class_1657 sender) {
        return Optional.ofNullable(sender.method_5682()).map(minecraftServer -> {
            class_2170 commandManager = minecraftServer.method_3734();
            CommandDispatcher dispatcher = commandManager.method_9235();
            RootCommandNode root = dispatcher.getRoot();
            return root.getChild("give");
        });
    }

    private static /* synthetic */ class_2561 lambda$notifyGive$1(class_2561 message) {
        return message;
    }
}

