package mezz.jei.common.util;

import javax.annotation.Nullable;
import net.minecraft.class_1074;
import net.minecraft.class_1076;
import net.minecraft.class_310;
import java.util.Locale;

public final class Translator {
	@Nullable
	private static String cachedLocaleCode;
	@Nullable
	private static Locale cachedLocale;

	private Translator() {
	}

	public static String translateToLocal(String key) {
		return class_1074.method_4662(key);
	}

	public static String translateToLocalFormatted(String key, Object... format) {
		return class_1074.method_4662(key, format);
	}

	public static String toLowercaseWithLocale(String string) {
		return string.toLowerCase(getLocale());
	}

	@SuppressWarnings("ConstantConditions")
	private static Locale getLocale() {
		class_310 minecraft = class_310.method_1551();
		if (minecraft == null) {
			return Locale.getDefault();
		}
		class_1076 languageManager = minecraft.method_1526();
		String code = languageManager.method_4669();
		if (cachedLocale == null || !code.equals(cachedLocaleCode)) {
			cachedLocaleCode = code;
			String[] splitLangCode = code.split("_", 2);
			if (splitLangCode.length == 1) { // Vanilla has some languages without underscores
				cachedLocale = new Locale(code);
			} else {
				cachedLocale = new Locale(splitLangCode[0], splitLangCode[1]);
			}
		}
		return cachedLocale;
	}
}
