package mezz.jei.common.transfer;

import net.minecraft.class_1703;
import net.minecraft.class_1735;
import net.minecraft.class_2540;

/**
 * Represents transferring an ItemStack from inventorySlot to craftingSlot.
 */
public record TransferOperation(class_1735 inventorySlot, class_1735 craftingSlot) {
	public static TransferOperation readPacketData(class_2540 buf, class_1703 container) {
		int inventorySlotIndex = buf.method_10816();
		int craftingSlotIndex = buf.method_10816();

		class_1735 inventorySlot = container.method_7611(inventorySlotIndex);
		class_1735 craftingSlot = container.method_7611(craftingSlotIndex);
		return new TransferOperation(inventorySlot, craftingSlot);
	}

	public void writePacketData(class_2540 buf) {
		buf.method_10804(inventorySlot.field_7874);
		buf.method_10804(craftingSlot.field_7874);
	}
}
