package mezz.jei.gui.ghost;

import com.mojang.blaze3d.systems.RenderSystem;
import mezz.jei.api.gui.handlers.IGhostIngredientHandler;
import mezz.jei.api.gui.handlers.IGhostIngredientHandler.Target;
import mezz.jei.api.ingredients.IIngredientRenderer;
import mezz.jei.api.ingredients.ITypedIngredient;
import mezz.jei.common.util.ImmutableRect2i;
import mezz.jei.common.util.MathUtil;
import mezz.jei.gui.input.UserInput;
import net.minecraft.class_241;
import net.minecraft.class_287;
import net.minecraft.class_289;
import net.minecraft.class_290;
import net.minecraft.class_293;
import net.minecraft.class_332;
import net.minecraft.class_4587;
import net.minecraft.class_5944;
import net.minecraft.class_757;
import net.minecraft.class_768;
import org.lwjgl.opengl.GL11;

import java.util.List;

public class GhostIngredientDrag<T> {
	private static final int targetColor = 0x4013C90A;
	private static final int hoverColor = 0x804CC919;

	private final IGhostIngredientHandler<?> handler;
	private final List<Target<T>> targets;
	private final List<class_768> targetAreas;
	private final IIngredientRenderer<T> ingredientRenderer;
	private final ITypedIngredient<T> ingredient;
	private final double mouseStartX;
	private final double mouseStartY;
	private final ImmutableRect2i origin;

	public GhostIngredientDrag(
		IGhostIngredientHandler<?> handler,
		List<Target<T>> targets,
		IIngredientRenderer<T> ingredientRenderer,
		ITypedIngredient<T> ingredient,
		double mouseX,
		double mouseY,
		ImmutableRect2i origin
	) {
		this.handler = handler;
		this.targets = targets;
		this.targetAreas = targets.stream()
			.map(Target::getArea)
			.toList();
		this.ingredientRenderer = ingredientRenderer;
		this.ingredient = ingredient;
		this.origin = origin;
		this.mouseStartX = mouseX;
		this.mouseStartY = mouseY;
	}

	public void drawTargets(class_332 guiGraphics, int mouseX, int mouseY) {
		if (handler.shouldHighlightTargets()) {
			drawTargets(guiGraphics, mouseX, mouseY, targetAreas);
		}
	}

	public static boolean farEnoughToDraw(GhostIngredientDrag<?> drag, double mouseX, double mouseY) {
		ImmutableRect2i origin = drag.getOrigin();
		final class_241 center;
		if (origin.isEmpty()) {
			center = new class_241((float) drag.mouseStartX, (float) drag.mouseStartY);
		} else {
			center = new class_241(
				origin.getX() + (origin.getWidth() / 2.0f),
				origin.getY() + (origin.getHeight() / 2.0f)
			);
		}

		double mouseXDist = center.field_1343 - mouseX;
		double mouseYDist = center.field_1342 - mouseY;
		double mouseDistSq = mouseXDist * mouseXDist + mouseYDist * mouseYDist;
		return mouseDistSq > 64.0;
	}

	public void drawItem(class_332 guiGraphics, int mouseX, int mouseY) {
		if (!farEnoughToDraw(this, mouseX, mouseY)) {
			return;
		}

		if (!origin.isEmpty()) {
			int originX = origin.getX() + (origin.getWidth() / 2);
			int originY = origin.getY() + (origin.getHeight() / 2);

			RenderSystem.disableDepthTest();
			RenderSystem.depthMask(false);

			var oldShader = RenderSystem.getShader();
			RenderSystem.setShader(class_757::method_34540);

			GL11.glEnable(GL11.GL_LINE_SMOOTH);
			GL11.glHint(GL11.GL_LINE_SMOOTH_HINT, GL11.GL_NICEST);

			var tesselator = RenderSystem.renderThreadTesselator();
			var builder = tesselator.method_1349();
			builder.method_1328(class_293.class_5596.field_29344, class_290.field_1576);
			float red = (targetColor >> 24 & 255) / 255.0F;
			float green = (targetColor >> 16 & 255) / 255.0F;
			float blue = (targetColor >> 8 & 255) / 255.0F;
			float alpha = (targetColor & 255) / 255.0F;
			builder.method_22912(mouseX, mouseY, 150).method_22915(red, green, blue, alpha).method_1344();
			builder.method_22912(originX, originY, 150).method_22915(red, green, blue, alpha).method_1344();
			tesselator.method_1350();

			RenderSystem.setShader(() -> oldShader);
			RenderSystem.enableDepthTest();
			RenderSystem.depthMask(true);
		}

		var poseStack = guiGraphics.method_51448();
		poseStack.method_22903();
		{
			poseStack.method_46416(mouseX - 8, mouseY - 8, 0);
			ingredientRenderer.render(guiGraphics, ingredient.getIngredient());
		}
		poseStack.method_22909();
	}

	public static void drawTargets(class_332 guiGraphics, int mouseX, int mouseY, List<class_768> targetAreas) {
		RenderSystem.disableDepthTest();
		for (class_768 area : targetAreas) {
			int color;
			if (MathUtil.contains(area, mouseX, mouseY)) {
				color = hoverColor;
			} else {
				color = targetColor;
			}
			guiGraphics.method_25294(area.method_3321(), area.method_3322(), area.method_3321() + area.method_3319(), area.method_3322() + area.method_3320(), color);
		}
		RenderSystem.setShaderColor(1f, 1f, 1f, 1f);
	}

	public boolean onClick(UserInput input) {
		for (Target<T> target : targets) {
			class_768 area = target.getArea();
			if (MathUtil.contains(area, input.getMouseX(), input.getMouseY())) {
				if (!input.isSimulate()) {
					target.accept(ingredient.getIngredient());
					handler.onComplete();
				}
				return true;
			}
		}
		if (!input.isSimulate()) {
			handler.onComplete();
		}
		return false;
	}

	public void stop() {
		handler.onComplete();
	}

	public IIngredientRenderer<T> getIngredientRenderer() {
		return ingredientRenderer;
	}

	public ITypedIngredient<T> getIngredient() {
		return ingredient;
	}

	public ImmutableRect2i getOrigin() {
		return origin;
	}
}
