package mezz.jei.fabric.platform;

import mezz.jei.common.platform.IPlatformItemStackHelper;
import net.fabricmc.fabric.api.registry.FuelRegistry;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1836;
import net.minecraft.class_2561;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.Nullable;

import java.util.List;
import java.util.Objects;
import java.util.Optional;

public class ItemStackHelper implements IPlatformItemStackHelper {
    private static final Logger LOGGER = LogManager.getLogger();

    @Override
    public int getBurnTime(class_1799 itemStack) {
        return Objects.requireNonNullElse(FuelRegistry.INSTANCE.get(itemStack.method_7909()), 0);
    }

    @Override
    public boolean isBookEnchantable(class_1799 stack, class_1799 book) {
        return true;
    }

    @Override
    public Optional<String> getCreatorModId(class_1799 stack) {
        return Optional.empty();
    }

    @Override
    public List<class_2561> getTestTooltip(@Nullable class_1657 player, class_1799 itemStack) {
        try {
            return itemStack.method_7950(player, class_1836.class_1837.field_41070);
        } catch (LinkageError | RuntimeException e) {
            LOGGER.error("Error while Testing for mod name formatting", e);
        }
        return List.of();
    }
}
