package mezz.jei.common.network.packets;

import com.google.common.base.Preconditions;
import mezz.jei.common.network.IPacketId;
import mezz.jei.common.network.PacketIdServer;
import mezz.jei.common.network.ServerPacketContext;
import mezz.jei.common.network.ServerPacketData;
import mezz.jei.common.util.ServerCommandUtil;
import mezz.jei.common.util.ErrorUtil;
import net.minecraft.class_1661;
import net.minecraft.class_1799;
import net.minecraft.class_2540;
import net.minecraft.class_3222;
import net.minecraft.server.MinecraftServer;
import java.util.concurrent.CompletableFuture;

public class PacketSetHotbarItemStack extends PacketJei {
	private final class_1799 itemStack;
	private final int hotbarSlot;

	public PacketSetHotbarItemStack(class_1799 itemStack, int hotbarSlot) {
		ErrorUtil.checkNotNull(itemStack, "itemStack");
		Preconditions.checkArgument(class_1661.method_7380(hotbarSlot), "hotbar slot must be in the hotbar. got: " + hotbarSlot);
		this.itemStack = itemStack;
		this.hotbarSlot = hotbarSlot;
	}

	@Override
	public IPacketId getPacketId() {
		return PacketIdServer.SET_HOTBAR_ITEM;
	}

	@Override
	public void writePacketData(class_2540 buf) {
		buf.method_10793(itemStack);
		buf.method_10804(hotbarSlot);
	}

	public static CompletableFuture<Void> readPacketData(ServerPacketData data) {
		class_2540 buf = data.buf();
		class_1799 itemStack = buf.method_10819();
		int hotbarSlot = buf.method_10816();
		ServerPacketContext context = data.context();
		class_3222 player = context.player();
		MinecraftServer server = player.field_13995;
		return server.method_20493(() -> ServerCommandUtil.setHotbarSlot(context, itemStack, hotbarSlot));
	}
}
