package mezz.jei.api.fabric.ingredients.fluids;

import java.util.Optional;
import net.minecraft.class_2487;
import net.minecraft.class_3611;

/**
 * Built-in ingredient for representing Fluids in Fabric Minecraft.
 *
 * @since 10.1.0
 */
public interface IJeiFluidIngredient {
    /**
     * @return the fluid represented by this ingredient.
     *
     * @since 10.1.0
     */
    class_3611 getFluid();

    /**
     * @return the amount of fluid.
     *
     * @since 10.1.0
     */
    long getAmount();

    /**
     * @return optionally any {@link class_2487} extra data for this fluid ingredient.
     *
     * @since 10.1.0
     */
    Optional<class_2487> getTag();
}
