package mezz.jei.fabric.input;

import java.util.function.Consumer;
import mezz.jei.common.input.keys.IJeiKeyMappingInternal;
import mezz.jei.common.input.keys.JeiKeyConflictContext;
import mezz.jei.common.input.keys.JeiKeyModifier;
import net.minecraft.class_2561;
import net.minecraft.class_304;
import net.minecraft.class_3675;

public class FabricJeiKeyMapping implements IJeiKeyMappingInternal {
    private final String category;
    private final String description;
    private final JeiKeyConflictContext context;
    private final JeiKeyModifier modifier;
    private final class_3675.class_307 type;
    private final class_3675.class_306 key;

    public FabricJeiKeyMapping(
        String category,
        String description,
        JeiKeyConflictContext context,
        JeiKeyModifier modifier,
        class_3675.class_307 type,
        int keyCode
    ) {
        this.category = category;
        this.description = description;
        this.context = context;
        this.modifier = modifier;
        this.type = type;
        this.key = type.method_1447(keyCode);
    }

    @Override
    public boolean isActiveAndMatches(class_3675.class_306 key) {
        if (isUnbound()) {
            return false;
        }
        if (!this.key.equals(key)) {
            return false;
        }
        return context.isActive() && modifier.isActive(context);
    }

    @Override
    public boolean isUnbound() {
        return this.key.equals(class_3675.field_16237);
    }

    @Override
    public class_2561 getTranslatedKeyMessage() {
        return modifier.getCombinedName(key);
    }

    @Override
    public IJeiKeyMappingInternal register(Consumer<class_304> registerMethod) {
        return this;
    }
}
