package mezz.jei.fabric.ingredients.fluid;

import mezz.jei.api.fabric.ingredients.fluids.IJeiFluidIngredient;
import net.minecraft.class_2487;
import net.minecraft.class_3611;
import javax.annotation.Nullable;
import java.util.Optional;

public final class JeiFluidIngredient implements IJeiFluidIngredient {
    private final class_3611 fluid;
    private final long amount;
    @Nullable
    private final class_2487 tag;

    public JeiFluidIngredient(class_3611 fluid, long amount) {
        this.fluid = fluid;
        this.amount = amount;
        this.tag = null;
    }

    public JeiFluidIngredient(class_3611 fluid, long amount, @Nullable class_2487 tag) {
        this.fluid = fluid;
        this.amount = amount;
        if (tag != null) {
            this.tag = tag.method_10553();
        } else {
            this.tag = null;
        }
    }

    @Override
    public class_3611 getFluid() {
        return fluid;
    }

    @Override
    public long getAmount() {
        return amount;
    }

    @Override
    public Optional<class_2487> getTag() {
        return Optional.ofNullable(tag);
    }
}
